/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditorAddDialog;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassFilterEditor
extends JPanel
implements ComponentWithEmptyText {
    protected JBTable myTable = null;
    protected FilterTableModel myTableModel = null;
    protected final Project myProject;
    private final com.intellij.ide.util.ClassFilter myChooserFilter;
    @Nullable
    private final String myPatternsHelpId;
    private String classDelimiter = "$";

    public ClassFilterEditor(Project project) {
        this(project, null);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter) {
        this(project, classFilter, null);
    }

    public ClassFilterEditor(Project project, com.intellij.ide.util.ClassFilter classFilter, @Nullable String patternsHelpId) {
        super(new BorderLayout());
        this.myPatternsHelpId = patternsHelpId;
        this.myTable = new JBTable();
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTable).addExtraAction(new AnActionButton(this.getAddButtonText(), this.getAddButtonIcon()){

            @Override
            public void actionPerformed(AnActionEvent e) {
                ClassFilterEditor.this.addClassFilter();
            }

            @Override
            public void updateButton(AnActionEvent e) {
                super.updateButton(e);
                this.setEnabled(!ClassFilterEditor.this.myProject.isDefault());
            }
        });
        if (this.addPatternButtonVisible()) {
            decorator.addExtraAction(new AnActionButton(this.getAddPatternButtonText(), this.getAddPatternButtonIcon()){

                @Override
                public void actionPerformed(AnActionEvent e) {
                    ClassFilterEditor.this.addPatternFilter();
                }

                @Override
                public void updateButton(AnActionEvent e) {
                    super.updateButton(e);
                    this.setEnabled(!ClassFilterEditor.this.myProject.isDefault());
                }
            });
        }
        this.add((Component)decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)ClassFilterEditor.this.myTable);
            }
        }).setButtonComparator(this.getAddButtonText(), this.getAddPatternButtonText(), "Remove").disableUpDownActions().createPanel(), "Center");
        this.myChooserFilter = classFilter;
        this.myProject = project;
        this.myTableModel = new FilterTableModel();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setTableHeader(null);
        this.myTable.setAutoResizeMode(3);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(200, this.myTable.getRowHeight() * 7));
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)column);
        column.setCellRenderer(new EnabledCellRenderer(this.myTable.getDefaultRenderer(Boolean.class)));
        columnModel.getColumn(1).setCellRenderer(new FilterCellRenderer());
        this.getEmptyText().setText(UIBundle.message((String)"no.patterns", (Object[])new Object[0]));
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myTable.getEmptyText();
        if (statusText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/classFilter/ClassFilterEditor", "getEmptyText"));
        }
        return statusText;
    }

    protected String getAddButtonText() {
        return UIBundle.message((String)"button.add.class", (Object[])new Object[0]);
    }

    protected String getAddPatternButtonText() {
        return UIBundle.message((String)"button.add.pattern", (Object[])new Object[0]);
    }

    protected Icon getAddButtonIcon() {
        return IconUtil.getAddClassIcon();
    }

    protected Icon getAddPatternButtonIcon() {
        return IconUtil.getAddPatternIcon();
    }

    protected boolean addPatternButtonVisible() {
        return true;
    }

    public void setFilters(ClassFilter[] filters) {
        this.myTableModel.setFilters(filters);
    }

    public ClassFilter[] getFilters() {
        return this.myTableModel.getFilters();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myTable.setEnabled(enabled);
        this.myTable.setRowSelectionAllowed(enabled);
        this.myTableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        TableCellEditor editor = this.myTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    @NotNull
    protected ClassFilter createFilter(String pattern) {
        ClassFilter classFilter = new ClassFilter(pattern);
        if (classFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/classFilter/ClassFilterEditor", "createFilter"));
        }
        return classFilter;
    }

    protected void addPatternFilter() {
        String pattern;
        ClassFilterEditorAddDialog dialog = new ClassFilterEditorAddDialog(this.myProject, this.myPatternsHelpId);
        if (dialog.showAndGet() && (pattern = dialog.getPattern()) != null) {
            ClassFilter filter = this.createFilter(pattern);
            this.myTableModel.addRow(filter);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myTable, true));
        }
    }

    protected void addClassFilter() {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(UIBundle.message((String)"class.filter.editor.choose.class.title", (Object[])new Object[0]), GlobalSearchScope.allScope(this.myProject), this.myChooserFilter, null);
        chooser.showDialog();
        PsiClass selectedClass = chooser.getSelected();
        if (selectedClass != null) {
            ClassFilter filter = this.createFilter(this.getJvmClassName(selectedClass));
            this.myTableModel.addRow(filter);
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myTable, true));
        }
    }

    @Nullable
    private String getJvmClassName(PsiClass aClass) {
        PsiClass parentClass = PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, true);
        if (parentClass != null) {
            String parentName = this.getJvmClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + this.classDelimiter + aClass.getName();
        }
        return aClass.getQualifiedName();
    }

    public void setClassDelimiter(String classDelimiter) {
        this.classDelimiter = classDelimiter;
    }

    public void addPattern(String pattern) {
        ClassFilter filter = this.createFilter(pattern);
        this.myTableModel.addRow(filter);
    }

    private class EnabledCellRenderer
    extends DefaultTableCellRenderer {
        private final TableCellRenderer myDelegate;

        public EnabledCellRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setEnabled(ClassFilterEditor.this.isEnabled());
            return component;
        }
    }

    private class FilterCellRenderer
    extends DefaultTableCellRenderer {
        private FilterCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = UIUtil.getTableFocusCellBackground();
            UIManager.put("Table.focusCellBackground", table.getSelectionBackground());
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                ((JLabel)component).setBorder(noFocusBorder);
            }
            UIManager.put("Table.focusCellBackground", color);
            ClassFilter filter = (ClassFilter)table.getValueAt(row, 1);
            component.setEnabled(isSelected || ClassFilterEditor.this.isEnabled() && filter.isEnabled());
            return component;
        }
    }

    protected final class FilterTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<ClassFilter> myFilters = new LinkedList<ClassFilter>();
        public static final int CHECK_MARK = 0;
        public static final int FILTER = 1;

        protected FilterTableModel() {
        }

        public final void setFilters(ClassFilter[] filters) {
            this.myFilters.clear();
            if (filters != null) {
                ContainerUtil.addAll(this.myFilters, (Object[])filters);
            }
            this.fireTableDataChanged();
        }

        public ClassFilter[] getFilters() {
            Iterator<ClassFilter> it = this.myFilters.iterator();
            while (it.hasNext()) {
                ClassFilter filter = it.next();
                String pattern = filter.getPattern();
                if (pattern != null && !"".equals(pattern)) continue;
                it.remove();
            }
            return this.myFilters.toArray(new ClassFilter[this.myFilters.size()]);
        }

        public ClassFilter getFilterAt(int index) {
            return this.myFilters.get(index);
        }

        public int getFilterIndex(ClassFilter filter) {
            return this.myFilters.indexOf(filter);
        }

        public void addRow(ClassFilter filter) {
            this.myFilters.add(filter);
            int row = this.myFilters.size() - 1;
            this.fireTableRowsInserted(row, row);
        }

        @Override
        public int getRowCount() {
            return this.myFilters.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ClassFilter filter = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                return filter;
            }
            if (columnIndex == 0) {
                return filter.isEnabled();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            ClassFilter filter = this.myFilters.get(rowIndex);
            if (columnIndex == 1) {
                filter.setPattern(aValue != null ? aValue.toString() : "");
            } else if (columnIndex == 0) {
                filter.setEnabled(aValue == null || (Boolean)aValue != false);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return ClassFilterEditor.this.isEnabled();
        }

        public void removeRow(int idx) {
            this.myFilters.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
    }
}

