/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.rules.MergeableUsage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends Node
implements Navigatable,
Comparable<GroupNode> {
    private static final NodeComparator COMPARATOR = new NodeComparator();
    private final int myRuleIndex;
    private int myRecursiveUsageCount;
    private final List<Node> myChildren = new SmartList();

    GroupNode(Node parent, @Nullable UsageGroup group, int ruleIndex) {
        this.setUserObject(group);
        this.setParent(parent);
        this.myRuleIndex = ruleIndex;
    }

    @Override
    protected void updateNotify() {
        if (this.getGroup() != null) {
            this.getGroup().update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        String result = this.getGroup() == null ? "" : this.getGroup().getText(null);
        GroupNode groupNode = this;
        synchronized (groupNode) {
            List<Node> children = this.myChildren;
            return result + children.subList(0, Math.min(10, children.size()));
        }
    }

    @NotNull
    List<Node> getChildren() {
        List<Node> list = this.myChildren;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getChildren"));
        }
        return list;
    }

    @NotNull
    List<Node> getSwingChildren() {
        List list = (List)ObjectUtils.notNull((Object)this.children, Collections.emptyList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getSwingChildren"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    GroupNode addOrGetGroup(@NotNull UsageGroup group, int ruleIndex, @NotNull Consumer<Node> edtInsertedUnderQueue) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/usages/impl/GroupNode", "addOrGetGroup"));
        }
        if (edtInsertedUnderQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtInsertedUnderQueue", "com/intellij/usages/impl/GroupNode", "addOrGetGroup"));
        }
        GroupNode newNode = new GroupNode(this, group, ruleIndex);
        GroupNode groupNode = this;
        synchronized (groupNode) {
            int insertionIndex = GroupNode.getNodeIndex(newNode, this.myChildren);
            if (insertionIndex >= 0) {
                GroupNode groupNode2 = (GroupNode)this.myChildren.get(insertionIndex);
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
                if (groupNode2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "addOrGetGroup"));
                }
                return groupNode2;
            }
            int i2 = -insertionIndex - 1;
            this.myChildren.add(i2, newNode);
        }
        edtInsertedUnderQueue.consume((Object)this);
        GroupNode groupNode3 = newNode;
        if (groupNode3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "addOrGetGroup"));
        }
        return groupNode3;
    }

    private static int getNodeIndex(@NotNull Node newNode, @NotNull List<Node> children) {
        if (newNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newNode", "com/intellij/usages/impl/GroupNode", "getNodeIndex"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/usages/impl/GroupNode", "getNodeIndex"));
        }
        int low = 0;
        int high = children.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            Node child = children.get(mid);
            int cmp = COMPARATOR.compare(child, newNode);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int getNodeInsertionIndex(@NotNull Node node, @NotNull List<Node> children) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode", "getNodeInsertionIndex"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/usages/impl/GroupNode", "getNodeInsertionIndex"));
        }
        int i2 = GroupNode.getNodeIndex(node, children);
        return i2 >= 0 ? i2 : -i2 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTargetsNode(@NotNull Node node, @NotNull DefaultTreeModel treeModel) {
        int index;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/usages/impl/GroupNode", "addTargetsNode"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/usages/impl/GroupNode", "addTargetsNode"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            index = GroupNode.getNodeInsertionIndex(node, this.getSwingChildren());
            this.myChildren.add(index, node);
        }
        treeModel.insertNodeInto(node, this, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllChildren() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.removeAllChildren();
        GroupNode groupNode = this;
        synchronized (groupNode) {
            this.myChildren.clear();
        }
        this.myRecursiveUsageCount = 0;
    }

    @Nullable
    private UsageNode tryMerge(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/GroupNode", "tryMerge"));
        }
        if (!(usage instanceof MergeableUsage)) {
            return null;
        }
        MergeableUsage mergeableUsage = (MergeableUsage)((Object)usage);
        for (UsageNode node : this.getUsageNodes()) {
            Usage original = node.getUsage();
            if (original == mergeableUsage) {
                return node;
            }
            if (!(original instanceof MergeableUsage) || !((MergeableUsage)((Object)original)).merge(mergeableUsage)) continue;
            return node;
        }
        return null;
    }

    void removeUsage(@NotNull UsageNode usage, @NotNull DefaultTreeModel treeModel) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/GroupNode", "removeUsage"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/usages/impl/GroupNode", "removeUsage"));
        }
        this.removeUsagesBulk(Collections.singleton(usage), treeModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeUsagesBulk(@NotNull Set<UsageNode> usages, @NotNull DefaultTreeModel treeModel) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/usages/impl/GroupNode", "removeUsagesBulk"));
        }
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/usages/impl/GroupNode", "removeUsagesBulk"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int removed = 0;
        GroupNode groupNode = this;
        synchronized (groupNode) {
            SmartList removedNodes = new SmartList();
            for (UsageNode usage : usages) {
                if (!this.myChildren.remove(usage)) continue;
                removedNodes.add(usage);
                ++removed;
            }
            if (removed == 0) {
                for (GroupNode groupNode2 : this.getSubGroups()) {
                    int delta = groupNode2.removeUsagesBulk(usages, treeModel);
                    if (delta <= 0) continue;
                    if (groupNode2.getRecursiveUsageCount() == 0) {
                        this.myChildren.remove(groupNode2);
                        removedNodes.add(groupNode2);
                    }
                    if ((removed += delta) != usages.size()) continue;
                    break;
                }
            }
            if (this.myChildren.size() > 0) {
                GroupNode.removeNodesFromParent(treeModel, this, (List<MutableTreeNode>)removedNodes);
            }
        }
        if (removed > 0) {
            this.myRecursiveUsageCount -= removed;
            if (this.myRecursiveUsageCount != 0) {
                treeModel.nodeChanged(this);
            }
        }
        return removed;
    }

    private static void removeNodesFromParent(@NotNull DefaultTreeModel treeModel, @NotNull GroupNode parent, @NotNull List<MutableTreeNode> nodes) {
        if (treeModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeModel", "com/intellij/usages/impl/GroupNode", "removeNodesFromParent"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/usages/impl/GroupNode", "removeNodesFromParent"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/usages/impl/GroupNode", "removeNodesFromParent"));
        }
        int count = nodes.size();
        if (count == 0) {
            return;
        }
        ObjectIntHashMap ordering = new ObjectIntHashMap(count);
        for (MutableTreeNode node : nodes) {
            ordering.put((Object)node, parent.getIndex(node));
        }
        Collections.sort(nodes, Comparator.comparingInt(arg_0 -> ((ObjectIntHashMap)ordering).get(arg_0)));
        int[] indices = ordering.getValues();
        Arrays.sort(indices);
        for (int i2 = count - 1; i2 >= 0; --i2) {
            parent.remove(indices[i2]);
        }
        treeModel.nodesWereRemoved(parent, indices, nodes.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    UsageNode addUsage(@NotNull Usage usage, @NotNull Consumer<Node> edtInsertedUnderQueue, boolean filterDuplicateLines) {
        UsageNode newNode;
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/usages/impl/GroupNode", "addUsage"));
        }
        if (edtInsertedUnderQueue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edtInsertedUnderQueue", "com/intellij/usages/impl/GroupNode", "addUsage"));
        }
        GroupNode groupNode = this;
        synchronized (groupNode) {
            UsageNode mergedWith;
            if (filterDuplicateLines && (mergedWith = this.tryMerge(usage)) != null) {
                UsageNode usageNode = mergedWith;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var5_4
                if (usageNode == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "addUsage"));
                }
                return usageNode;
            }
            newNode = new UsageNode(this, usage);
            int index = GroupNode.getNodeInsertionIndex(newNode, this.myChildren);
            this.myChildren.add(index, newNode);
        }
        edtInsertedUnderQueue.consume((Object)this);
        UsageNode usageNode = newNode;
        if (usageNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "addUsage"));
        }
        return usageNode;
    }

    void incrementUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        GroupNode groupNode = this;
        while (true) {
            ++groupNode.myRecursiveUsageCount;
            TreeNode parent = groupNode.getParent();
            if (!(parent instanceof GroupNode)) {
                return;
            }
            groupNode = (GroupNode)parent;
        }
    }

    @Override
    public String tree2string(int indent, String lineSeparator) {
        StringBuffer result = new StringBuffer();
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        if (this.getGroup() != null) {
            result.append(this.getGroup());
        }
        result.append("[");
        result.append(lineSeparator);
        for (Node node : this.myChildren) {
            result.append(node.tree2string(indent + 4, lineSeparator));
            result.append(lineSeparator);
        }
        StringUtil.repeatSymbol((Appendable)result, (char)' ', (int)indent);
        result.append("]");
        result.append(lineSeparator);
        return result.toString();
    }

    @Override
    protected boolean isDataValid() {
        return this.getGroup() == null || this.getGroup().isValid();
    }

    @Override
    protected boolean isDataReadOnly() {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode element = enumeration.nextElement();
            if (!(element instanceof Node) || !((Node)element).isReadOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull GroupNode groupNode) {
        if (groupNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupNode", "com/intellij/usages/impl/GroupNode", "compareTo"));
        }
        if (this.myRuleIndex == groupNode.myRuleIndex) {
            return this.getGroup().compareTo(groupNode.getGroup());
        }
        return Integer.compare(this.myRuleIndex, groupNode.myRuleIndex);
    }

    public synchronized UsageGroup getGroup() {
        return (UsageGroup)this.getUserObject();
    }

    int getRecursiveUsageCount() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myRecursiveUsageCount;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (this.getGroup() != null) {
            this.getGroup().navigate(requestFocus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.getGroup() != null && this.getGroup().canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.getGroup() != null && this.getGroup().canNavigateToSource();
    }

    @Override
    protected boolean isDataExcluded() {
        for (Node node : this.myChildren) {
            if (node.isExcluded()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    protected String getText(@NotNull UsageView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/GroupNode", "getText"));
        }
        String string = this.getGroup().getText(view);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getText"));
        }
        return string;
    }

    @NotNull
    public synchronized Collection<GroupNode> getSubGroups() {
        ArrayList<GroupNode> list = new ArrayList<GroupNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof GroupNode)) continue;
            list.add((GroupNode)n);
        }
        ArrayList<GroupNode> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getSubGroups"));
        }
        return arrayList;
    }

    @NotNull
    public synchronized Collection<UsageNode> getUsageNodes() {
        ArrayList<UsageNode> list = new ArrayList<UsageNode>();
        for (Node n : this.myChildren) {
            if (!(n instanceof UsageNode)) continue;
            list.add((UsageNode)n);
        }
        ArrayList<UsageNode> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/GroupNode", "getUsageNodes"));
        }
        return arrayList;
    }

    private static class NodeComparator
    implements Comparator<DefaultMutableTreeNode> {
        private NodeComparator() {
        }

        private static ClassIndex getClassIndex(DefaultMutableTreeNode node) {
            if (node instanceof UsageNode) {
                return ClassIndex.USAGE;
            }
            if (node instanceof GroupNode) {
                return ClassIndex.GROUP;
            }
            if (node instanceof UsageTargetNode) {
                return ClassIndex.USAGE_TARGET;
            }
            return ClassIndex.UNKNOWN;
        }

        @Override
        public int compare(DefaultMutableTreeNode n1, DefaultMutableTreeNode n2) {
            ClassIndex classIdx2;
            ClassIndex classIdx1 = NodeComparator.getClassIndex(n1);
            if (classIdx1 != (classIdx2 = NodeComparator.getClassIndex(n2))) {
                return classIdx1.compareTo(classIdx2);
            }
            if (classIdx1 == ClassIndex.GROUP) {
                return ((GroupNode)n1).compareTo((GroupNode)n2);
            }
            if (classIdx1 == ClassIndex.USAGE) {
                return ((UsageNode)n1).compareTo((UsageNode)n2);
            }
            return 0;
        }

        static enum ClassIndex {
            UNKNOWN,
            USAGE_TARGET,
            GROUP,
            USAGE;

        }
    }
}

