/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties> {
    private JpsMavenRepositoryLibraryDescriptor myDescriptor;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(String mavenId, boolean includeTransitiveDependencies) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, includeTransitiveDependencies);
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        this(groupId, artifactId, version, true);
    }

    public RepositoryLibraryProperties(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean includeTransitiveDependencies) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "<init>"));
        }
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RepositoryLibraryProperties && Comparing.equal((Object)this.myDescriptor, (Object)((RepositoryLibraryProperties)obj).myDescriptor);
    }

    @Override
    public int hashCode() {
        return Comparing.hashcode((Object)this.getMavenId());
    }

    @Override
    public RepositoryLibraryProperties getState() {
        return this;
    }

    @Override
    public void loadState(RepositoryLibraryProperties state) {
        this.myDescriptor = state.myDescriptor;
    }

    @Attribute(value="maven-id")
    public String getMavenId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getMavenId);
    }

    public void setMavenId(String mavenId) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, this.isIncludeTransitiveDependencies());
    }

    @Attribute(value="include-transitive-deps")
    public boolean isIncludeTransitiveDependencies() {
        return this.myDescriptor == null || this.myDescriptor.isIncludeTransitiveDependencies();
    }

    public void setIncludeTransitiveDependencies(boolean value) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), value);
    }

    public String getGroupId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getGroupId);
    }

    public String getArtifactId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getArtifactId);
    }

    public String getVersion() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getVersion);
    }

    public void changeVersion(String version) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getGroupId(), this.getArtifactId(), version, this.myDescriptor.isIncludeTransitiveDependencies());
    }

    private String call(Function<JpsMavenRepositoryLibraryDescriptor, String> method) {
        JpsMavenRepositoryLibraryDescriptor descriptor = this.myDescriptor;
        return descriptor != null ? method.apply(descriptor) : null;
    }

    @NotNull
    public JpsMavenRepositoryLibraryDescriptor getRepositoryLibraryDescriptor() {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.myDescriptor != null ? this.myDescriptor : new JpsMavenRepositoryLibraryDescriptor(null, true);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties", "getRepositoryLibraryDescriptor"));
        }
        return jpsMavenRepositoryLibraryDescriptor;
    }
}

