/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.completion.beans;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NameValueDescriptor {
    private String myName;
    private String myType;
    private boolean isRequired;
    private boolean isActionPreferred;

    public static NameValueDescriptor create(@Nullable String name) {
        return new NameValueDescriptor(name);
    }

    public static NameValueDescriptor create(@Nullable String name, @Nullable String type) {
        return new NameValueDescriptor(name, type);
    }

    public static NameValueDescriptor createExpression() {
        return new NameValueDescriptor();
    }

    public static NameValueDescriptor createAction() {
        return new NameValueDescriptor().setActionPreferred(true);
    }

    public static NameValueDescriptor createAction(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/completion/beans/NameValueDescriptor", "createAction"));
        }
        return new NameValueDescriptor(name).setActionPreferred(true);
    }

    public static NameValueDescriptor createStringExpression() {
        return new NameValueDescriptor(null, "java.lang.String");
    }

    public static NameValueDescriptor createStringExpression(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/completion/beans/NameValueDescriptor", "createStringExpression"));
        }
        return new NameValueDescriptor(name, "java.lang.String");
    }

    public boolean isActionPreferred() {
        return this.isActionPreferred;
    }

    public NameValueDescriptor setActionPreferred(boolean actionPreferred) {
        this.isActionPreferred = actionPreferred;
        return this;
    }

    public NameValueDescriptor() {
        this(null);
    }

    public NameValueDescriptor(@Nullable String name) {
        this(name, "java.lang.Object");
    }

    public NameValueDescriptor(@Nullable String name, @Nullable String type) {
        this.myName = name;
        this.myType = type;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public NameValueDescriptor setRequired(boolean required) {
        this.isRequired = required;
        return this;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    @NotNull
    public String getType() {
        String string = this.myType == null ? "java.lang.Object" : this.myType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/completion/beans/NameValueDescriptor", "getType"));
        }
        return string;
    }

    public NameValueDescriptor setType(@Nullable String type) {
        this.myType = type;
        return this;
    }

    public String getTailText() {
        return ":" + (this.isStringExpression() ? "''" : (this.isActionPreferred() ? "@" : ""));
    }

    public boolean isStringExpression() {
        return "java.lang.String".equals(this.getType());
    }

    public String getPresentableText() {
        return this.getName() + ":" + (this.isStringExpression() ? "''" : (this.isActionPreferred() ? "@'action'" : "expression"));
    }
}

