/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils.processors;

import com.intellij.openapi.project.Project;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.play.utils.PlayUtils;
import com.intellij.play.utils.beans.PlayImplicitVariable;
import com.intellij.play.utils.processors.PlayDeclarationsProcessor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightClass;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.hash.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class FieldTagImplicitVariablesProcessor
implements PlayDeclarationsProcessor {
    @Override
    public boolean processElement(PsiScopeProcessor processor, ResolveState state, PsiElement scope) {
        PlayImplicitVariable fieldVariable = FieldTagImplicitVariablesProcessor.getFieldTagImplicitVariables(scope);
        if (fieldVariable != null) {
            return ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)fieldVariable, (ResolveState)state);
        }
        return true;
    }

    @Nullable
    private static PlayImplicitVariable getFieldTagImplicitVariables(@NotNull PsiElement scope) {
        PsiClass objectClass;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor", "getFieldTagImplicitVariables"));
        }
        final PlayTag playTag = PlayUtils.getContainingPlayTag(scope);
        if (playTag != null && "field".equals(playTag.getName()) && (objectClass = PlayUtils.getObjectClass(scope.getProject())) != null) {
            final PsiElementFactory factory = JavaPsiFacade.getInstance((Project)scope.getProject()).getElementFactory();
            LightClass lightClass = new LightClass(objectClass){

                public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1", "processDeclarations"));
                    }
                    if (state == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1", "processDeclarations"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1", "processDeclarations"));
                    }
                    for (PlayImplicitVariable variable : this.getInnerFieldVariables()) {
                        if (ResolveUtil.processElement((PsiScopeProcessor)processor, (PsiNamedElement)variable, (ResolveState)state)) continue;
                        return true;
                    }
                    return false;
                }

                @NotNull
                private Set<PlayImplicitVariable> getInnerFieldVariables() {
                    HashSet set = new HashSet();
                    PsiClassType classType = factory.createType((PsiClass)new LightClass(objectClass){

                        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
                            if (processor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1$1", "processDeclarations"));
                            }
                            if (state == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1$1", "processDeclarations"));
                            }
                            if (place == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1$1", "processDeclarations"));
                            }
                            return false;
                        }
                    });
                    set.add(new PlayImplicitVariable("id", (PsiType)classType, (PsiElement)playTag));
                    set.add(new PlayImplicitVariable("name", (PsiType)classType, (PsiElement)playTag));
                    set.add(new PlayImplicitVariable("value", (PsiType)classType, (PsiElement)playTag));
                    set.add(new PlayImplicitVariable("error", (PsiType)classType, (PsiElement)playTag));
                    set.add(new PlayImplicitVariable("errorClass", (PsiType)classType, (PsiElement)playTag));
                    HashSet hashSet = set;
                    if (hashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/play/utils/processors/FieldTagImplicitVariablesProcessor$1", "getInnerFieldVariables"));
                    }
                    return hashSet;
                }
            };
            return new PlayImplicitVariable("field", (PsiType)factory.createType((PsiClass)lightClass), (PsiElement)playTag);
        }
        return null;
    }
}

