/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.DelimitedListProcessor;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.config.hints.StaticValuesReferenceProvider;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class MultiStaticValuesReferenceProvider
extends StaticValuesReferenceProvider {
    MultiStaticValuesReferenceProvider(boolean allowOtherValues, boolean caseInsensitive, String ... values) {
        super(allowOtherValues, caseInsensitive, values);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/MultiStaticValuesReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/MultiStaticValuesReferenceProvider", "getReferencesByElement"));
        }
        SmartList references = new SmartList();
        final String elementText = element.getText();
        final int offsetInElement = ElementManipulators.getOffsetInElement((PsiElement)element);
        new DelimitedListProcessor(",", (List)references){
            final /* synthetic */ List val$references;
            {
                this.val$references = list;
                super(x0);
            }

            protected void processToken(int start, int end, boolean delimitersOnly) {
                TextRange range = new TextRange(start + offsetInElement, end + offsetInElement);
                String valueText = range.substring(elementText);
                String valueTextTrimmed = valueText.trim();
                int valueTextIndex = valueText.indexOf(valueTextTrimmed);
                TextRange trimmedRange = TextRange.from((int)(range.getStartOffset() + valueTextIndex), (int)valueTextTrimmed.length());
                HintReferenceBase reference = MultiStaticValuesReferenceProvider.this.createValueReference(element);
                reference.setRangeInElement(trimmedRange);
                this.val$references.add(reference);
            }
        }.processText(elementText);
        PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/MultiStaticValuesReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

