/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import icons.SpringBootApiIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootAdditionalConfigAnnotator
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();
    private static final PsiElementListCellRenderer GOTO_HINT_GUTTER_RENDERER = new PsiElementListCellRenderer(){

        public String getElementText(PsiElement element) {
            JsonValue value = ((JsonProperty)element).getValue();
            assert (value != null);
            return ((JsonStringLiteral)value).getValue();
        }

        @Nullable
        protected String getContainerText(PsiElement element, String name) {
            return null;
        }

        protected int getIconFlags() {
            return 0;
        }

        @Nullable
        protected DefaultListCellRenderer getRightCellRenderer(Object value) {
            return null;
        }
    };

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "annotate"));
        }
        if (!(element instanceof JsonProperty)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof JsonFile)) {
            return;
        }
        if (!file.getName().equals("additional-spring-configuration-metadata.json")) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return;
        }
        JsonProperty jsonProperty = (JsonProperty)element;
        String name = jsonProperty.getName();
        if (name.equals("type") || name.equals("sourceType") || name.equals("target")) {
            SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        } else if (name.equals("description") || name.equals("reason")) {
            SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.DOC_COMMENT);
        } else if (name.equals("defaultValue")) {
            SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.METADATA);
        } else if (name.equals("value")) {
            SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.PARAMETER);
        } else if (name.equals("name") && SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            SpringBootAdditionalConfigAnnotator.installHintsGutterIcon(holder, (JsonFile)file, jsonProperty);
        }
    }

    private static void highlight(AnnotationHolder annotationHolder, JsonProperty jsonProperty, TextAttributesKey key) {
        JsonValue value = jsonProperty.getValue();
        if (value != null) {
            String message = DEBUG_MODE ? key.getExternalName() : null;
            annotationHolder.createInfoAnnotation((PsiElement)value, message).setTextAttributes(key);
        }
    }

    private static void installHintsGutterIcon(AnnotationHolder holder, JsonFile file, JsonProperty nameProperty) {
        List<JsonProperty> hintProperties = SpringBootAdditionalConfigAnnotator.findHints(file, nameProperty);
        if (hintProperties.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder.create((Icon)SpringBootApiIcons.SpringBoot).setTooltipText("Navigate to " + StringUtil.pluralize((String)"hint", (int)hintProperties.size())).setCellRenderer(GOTO_HINT_GUTTER_RENDERER).setTargets(hintProperties).install(holder, (PsiElement)nameProperty);
    }

    @NotNull
    private static List<JsonProperty> findHints(JsonFile file, JsonProperty nameProperty) {
        JsonProperty parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)nameProperty, JsonProperty.class);
        if (parentProperty == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
            }
            return list;
        }
        if (!parentProperty.getName().equals("properties")) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
            }
            return list;
        }
        JsonStringLiteral namePropertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class);
        if (namePropertyValue == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
            }
            return list;
        }
        String propertyName = namePropertyValue.getValue();
        JsonObject topValue = (JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), JsonObject.class);
        if (topValue == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
            }
            return list;
        }
        JsonProperty hintsProperty = topValue.findProperty("hints");
        if (hintsProperty == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
            }
            return list;
        }
        JsonArray hintsArray = (JsonArray)ObjectUtils.tryCast((Object)hintsProperty.getValue(), JsonArray.class);
        if (hintsArray == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
            }
            return list;
        }
        SmartList hintProperties = new SmartList();
        for (JsonValue hint : hintsArray.getValueList()) {
            String name;
            JsonStringLiteral nameValue;
            JsonProperty hintNameProperty;
            JsonObject hintObject = (JsonObject)ObjectUtils.tryCast((Object)hint, JsonObject.class);
            if (hintObject == null || (hintNameProperty = hintObject.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)hintNameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.startsWith((CharSequence)(name = nameValue.getValue()), (CharSequence)propertyName) || !name.equals(propertyName) && !name.equals(propertyName + ".keys") && !name.equals(propertyName + ".values")) continue;
            hintProperties.add(hintNameProperty);
        }
        SmartList smartList = hintProperties;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigAnnotator", "findHints"));
        }
        return smartList;
    }
}

