/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.spring.SpringInspectionsRegistry;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigInspection;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

public class SpringBootAdditionalConfigInspectionsRegistryContributor
implements SpringInspectionsRegistry.Contributor {
    public Class<? extends LocalInspectionTool>[] getInspectionClasses() {
        return new Class[]{SpringBootAdditionalConfigInspection.class};
    }

    public static class Contributor
    extends SpringInspectionsRegistry.AdditionalFilesContributor {
        public Collection<VirtualFile> getAdditionalFilesToProcess(Project project, CompileContext context) {
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
                return Collections.emptyList();
            }
            PsiPackage metaInfPackage = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
            if (metaInfPackage == null) {
                return Collections.emptyList();
            }
            GlobalSearchScope metaInfPackageScope = PackageScope.packageScopeWithoutLibraries((PsiPackage)metaInfPackage, (boolean)false);
            LinkedHashSet additionalFiles = ContainerUtil.newLinkedHashSet();
            for (Module module : context.getCompileScope().getAffectedModules()) {
                SpringFacet facet = SpringFacet.getInstance((Module)module);
                if (facet == null) continue;
                GlobalSearchScope moduleScope = module.getModuleScope(false).intersectWith(metaInfPackageScope);
                Collection additionalConfigs = FilenameIndex.getVirtualFilesByName((Project)project, (String)"additional-spring-configuration-metadata.json", (GlobalSearchScope)moduleScope);
                additionalFiles.addAll(additionalConfigs);
            }
            return additionalFiles;
        }
    }
}

