/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.banner;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.banner.AnsiColor;
import com.intellij.spring.boot.banner.AnsiStyle;
import com.intellij.spring.boot.banner.BuiltinProperty;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootBannerPropertyReference
extends PsiReferenceBase.Poly<PsiElement> {
    private final boolean myBoot13;

    SpringBootBannerPropertyReference(PsiElement element, TextRange range, boolean isSpringBoot13) {
        super(element, range, true);
        this.myBoot13 = isSpringBoot13;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] dummyResult = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.myElement});
        if (!this.myBoot13) {
            if (dummyResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
            }
            return dummyResult;
        }
        String value = this.getValue();
        for (BuiltinProperty property : BuiltinProperty.values()) {
            if (!property.getPropertyName().equals(value)) continue;
            if (dummyResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
            }
            return dummyResult;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiColor.")) {
            ResolveResult[] resolveResultArray = this.resolveAnsiColor(value, "AnsiColor.", "org.springframework.boot.ansi.AnsiColor");
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiBackground.")) {
            ResolveResult[] resolveResultArray = this.resolveAnsiColor(value, "AnsiBackground.", "org.springframework.boot.ansi.AnsiBackground");
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (StringUtil.startsWith((CharSequence)value, (CharSequence)"AnsiStyle.")) {
            ResolveResult[] resolveResultArray = this.resolveAnsiStyle(value, "AnsiStyle.");
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        List<MetaConfigKeyReference> references = this.resolveConfigValue(value);
        if (references != null) {
            List targets = references.stream().map(MetaConfigKeyReference::createNavigationElement).collect(Collectors.toList());
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(targets);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
            }
            return resolveResultArray;
        }
        if (dummyResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "multiResolve"));
        }
        return dummyResult;
    }

    @Nullable
    private List<MetaConfigKeyReference> resolveConfigValue(String value) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module == null) {
            return null;
        }
        SpringBootApplicationMetaConfigKey metaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, value);
        if (metaConfigKey == null) {
            return null;
        }
        SmartList results = new SmartList();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            for (VirtualFile virtualFile : contributor.getConfigurationFiles(module, false)) {
                SpringBootModelConfigFileContributor.ConfigurationValueResult result;
                PsiFile configPsiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
                if (configPsiFile == null || (result = contributor.findConfigurationValue(configPsiFile, metaConfigKey, true, null)) == null || result.keyElement == null) continue;
                ContainerUtil.addIfNotNull((Collection)results, (Object)ContainerUtil.findInstance((Object[])result.keyElement.getReferences(), MetaConfigKeyReference.class));
            }
        }
        return results.isEmpty() ? null : results;
    }

    @NotNull
    private ResolveResult[] resolveAnsiColor(String value, String prefix, String className) {
        String name = StringUtil.substringAfter((String)value, (String)prefix);
        AnsiColor ansiColor = AnsiColor.findByName(name);
        if (ansiColor == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "resolveAnsiColor"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.findFieldInClass(className, name)});
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "resolveAnsiColor"));
        }
        return resolveResultArray;
    }

    @NotNull
    private ResolveResult[] resolveAnsiStyle(String value, String prefix) {
        String name = StringUtil.substringAfter((String)value, (String)prefix);
        AnsiStyle ansiStyle = AnsiStyle.findByName(name);
        if (ansiStyle == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "resolveAnsiStyle"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.findFieldInClass("org.springframework.boot.ansi.AnsiStyle", name)});
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "resolveAnsiStyle"));
        }
        return resolveResultArray;
    }

    @Nullable
    private PsiField findFieldInClass(String className, String fieldName) {
        PsiClass psiClass = SpringCommonUtils.findLibraryClass((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()), (String)className);
        return psiClass != null ? psiClass.findFieldByName(fieldName, false) : null;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/banner/SpringBootBannerPropertyReference", "getVariants"));
        }
        return EMPTY_ARRAY;
    }
}

