/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.ui.CheckboxTreeAdapter;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import icons.SpringBootApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootCustomizationDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JPanel myTreePanel;
    private JPanel myTextFieldPanel;
    private TextFieldWithAutoCompletion<SpringConfigNameProposal> mySpringConfigNameTextField;
    private final Project myProject;
    private final SpringFileSet myFileSet;
    private CheckboxTreeBase myFilesTree;
    private ConfigFilesTreeBuilder myFilesTreeBuilder;
    private Set<PsiFile> myPsiFiles;
    private boolean foundConfigFilesByName;
    private List<VirtualFile> myCustomConfigFiles;
    private Module myModule;

    public SpringBootCustomizationDialog(Project project, SpringFileSet fileSet) {
        super(project);
        this.$$$setupUI$$$();
        this.myPsiFiles = new HashSet<PsiFile>();
        this.myCustomConfigFiles = new ArrayList<VirtualFile>();
        this.myProject = project;
        this.myFileSet = fileSet;
        this.myModule = fileSet.getFacet().getModule();
        this.setTitle("Spring Boot Context '" + this.myFileSet.getName() + "'");
        this.initUI();
        this.init();
    }

    protected void doOKAction() {
        CustomSetting.STRING configFileNameSetting = this.getConfigFileNameSetting();
        String configFileName = this.getConfigFileName();
        if (StringUtil.isEmpty((String)configFileName)) {
            configFileNameSetting.clear();
        } else {
            configFileNameSetting.setStringValue(configFileName);
        }
        CustomSetting.STRING customConfigFilesSetting = this.getCustomConfigFilesSetting();
        if (!this.myCustomConfigFiles.isEmpty()) {
            customConfigFilesSetting.setStringValue(StringUtil.join(this.myCustomConfigFiles, file -> file.getUrl(), (String)";"));
        } else {
            customConfigFilesSetting.clear();
        }
        super.doOKAction();
    }

    @NotNull
    private CustomSetting.STRING getConfigFileNameSetting() {
        CustomSetting.STRING sTRING = this.getCustomSetting((Key<CustomSetting.STRING>)SpringBootModelConfigFileContributor.SPRING_CONFIG_NAME_CUSTOM_SETTING_ID);
        if (sTRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog", "getConfigFileNameSetting"));
        }
        return sTRING;
    }

    @NotNull
    private CustomSetting.STRING getCustomConfigFilesSetting() {
        CustomSetting.STRING sTRING = this.getCustomSetting((Key<CustomSetting.STRING>)SpringBootModelConfigFileContributor.SPRING_CONFIG_CUSTOM_FILES_ID);
        if (sTRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog", "getCustomConfigFilesSetting"));
        }
        return sTRING;
    }

    @NotNull
    private CustomSetting.STRING getCustomSetting(Key<CustomSetting.STRING> id) {
        CustomSetting.STRING setting = (CustomSetting.STRING)this.myFileSet.getFacet().findSetting(id);
        assert (setting != null);
        CustomSetting.STRING sTRING = setting;
        if (sTRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog", "getCustomSetting"));
        }
        return sTRING;
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void initUI() {
        this.mySpringConfigNameTextField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new SpringConfigNameAutoCompletionListProvider(this.getSpringConfigNameProposals()), true, null);
        this.myTextFieldPanel.add((Component)this.mySpringConfigNameTextField);
        CustomSetting.STRING configFileNameSetting = this.getConfigFileNameSetting();
        if (configFileNameSetting.getStringValue() != configFileNameSetting.getDefaultValue()) {
            this.mySpringConfigNameTextField.setText(configFileNameSetting.getStringValue());
        }
        this.mySpringConfigNameTextField.setPlaceholder((CharSequence)("(not set, using default '" + configFileNameSetting.getDefaultValue() + "')"));
        this.mySpringConfigNameTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                SpringBootCustomizationDialog.this.updateTree();
            }
        });
        CustomSetting.STRING customConfigFilesSetting = this.getCustomConfigFilesSetting();
        String urls = customConfigFilesSetting.getStringValue();
        if (urls != null) {
            for (String url : StringUtil.split((String)urls, (String)";")) {
                VirtualFile customConfigFile = VirtualFileManager.getInstance().findFileByUrl(url);
                ContainerUtil.addIfNotNull(this.myCustomConfigFiles, (Object)customConfigFile);
            }
        }
        this.myFilesTree = new CheckboxTreeBase(new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ConfigFilesTreeBuilder.renderNode((Object)value, (boolean)expanded, (ColoredTreeCellRenderer)this.getTextRenderer());
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                if (object instanceof PsiFile) {
                    this.getTextRenderer().setIcon(SpringBootApiIcons.SpringBoot);
                } else if (object instanceof FileType) {
                    this.getTextRenderer().setIcon((Icon)new LayeredIcon(new Icon[]{AllIcons.Nodes.Folder, SpringBootApiIcons.SpringBoot_Overlay}));
                }
            }
        }, null, new CheckboxTreeBase.CheckPolicy(false, false, true, true)){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }
        };
        ConfigFilesTreeBuilder.installSearch((JTree)this.myFilesTree);
        this.myFilesTreeBuilder = new ConfigFilesTreeBuilder((JTree)this.myFilesTree){

            protected DefaultMutableTreeNode createFileNode(Object file) {
                CheckedTreeNode node = new CheckedTreeNode(file);
                if (file instanceof PsiFile) {
                    node.setChecked(true);
                    node.setEnabled(SpringBootCustomizationDialog.this.myCustomConfigFiles.contains(((PsiFile)file).getVirtualFile()));
                } else {
                    node.setChecked(false);
                    node.setEnabled(false);
                }
                return node;
            }
        };
        this.myFilesTree.addCheckboxTreeListener((CheckboxTreeListener)new CheckboxTreeAdapter(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$5", "nodeStateChanged"));
                }
                Object userObject = node.getUserObject();
                if (userObject instanceof PsiFile) {
                    VirtualFile configFile = ((PsiFile)userObject).getVirtualFile();
                    if (node.isChecked()) {
                        SpringBootCustomizationDialog.this.myCustomConfigFiles.add(configFile);
                    } else {
                        SpringBootCustomizationDialog.this.myCustomConfigFiles.remove(configFile);
                    }
                }
            }
        });
        this.myFilesTree.setRootVisible(false);
        this.myFilesTree.setShowsRootHandles(true);
        this.updateTree();
        JPanel panel = ToolbarDecorator.createDecorator((JTree)this.myFilesTree).setAddAction(button -> this.addCustomFiles()).setAddActionName("Add custom configuration files").createPanel();
        this.myTreePanel.add(panel);
    }

    private List<SpringConfigNameProposal> getSpringConfigNameProposals() {
        ArrayList<SpringConfigNameProposal> results = new ArrayList<SpringConfigNameProposal>();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            GlobalSearchScope searchScope = contributor.getConfigFileSearchScope(this.myModule, false);
            if (searchScope == null) continue;
            FileType fileType = contributor.getFileType();
            Collection allFiles = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)searchScope);
            for (VirtualFile file : allFiles) {
                String nameWithoutExtension = file.getNameWithoutExtension();
                if (StringUtil.containsChar((String)nameWithoutExtension, (char)'-') || "application".equals(nameWithoutExtension) || "bootstrap".equals(nameWithoutExtension)) continue;
                List configFilesByName = contributor.findApplicationConfigFiles(this.myModule, false, nameWithoutExtension);
                results.add(new SpringConfigNameProposal(fileType, nameWithoutExtension, configFilesByName));
            }
        }
        results.sort((o1, o2) -> StringUtil.naturalCompare((String)((SpringConfigNameProposal)o1).myName, (String)((SpringConfigNameProposal)o2).myName));
        return results;
    }

    private void addCustomFiles() {
        final Set configFileFiletypes = ContainerUtil.map2Set((Object[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions(), contributor -> contributor.getFileType());
        FileChooserDescriptor chooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!super.isFileVisible(file, showHiddenFiles)) {
                    return false;
                }
                if (file.isDirectory()) {
                    return !ProjectFileIndex.getInstance((Project)SpringBootCustomizationDialog.this.myProject).isExcluded(file);
                }
                if (!configFileFiletypes.contains(file.getFileType())) {
                    return false;
                }
                return SpringBootCustomizationDialog.this.myPsiFiles.stream().noneMatch(psiFile -> psiFile.getVirtualFile().equals(file));
            }
        }.withShowHiddenFiles(false).withTitle("Choose Custom Configuration Files").withRoots(ModuleRootManager.getInstance((Module)this.myModule).getContentRoots());
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(chooserDescriptor, this.myProject, (Component)this.myMainPanel);
        Object[] files = fileChooser.choose(this.myProject, new VirtualFile[0]);
        if (files.length != 0) {
            ContainerUtil.addAll(this.myCustomConfigFiles, (Object[])files);
            this.updateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTree() {
        CheckedTreeNode myRoot = new CheckedTreeNode(null);
        this.myFilesTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)myRoot));
        this.myPsiFiles.clear();
        this.myFilesTree.setPaintBusy(true);
        try {
            ConfigFileSearcher[] searchers;
            for (ConfigFileSearcher searcher : searchers = this.getSearchers()) {
                ContainerUtil.addAll(this.myPsiFiles, (Iterable)searcher.searchWithFiles());
            }
            this.myFilesTreeBuilder.buildTree((DefaultMutableTreeNode)this.myFilesTree.getModel().getRoot(), searchers);
            TreeUtil.expandAll((JTree)this.myFilesTree);
        }
        finally {
            this.myFilesTree.setPaintBusy(false);
        }
    }

    private ConfigFileSearcher[] getSearchers() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        final String defaultConfigName = this.getConfigFileNameSetting().getDefaultValue();
        this.foundConfigFilesByName = false;
        SmartList searchers = new SmartList();
        for (final SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            ConfigFileSearcher searcher = new ConfigFileSearcher(this.myModule, this.myModule.getProject()){

                public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$7", "search"));
                    }
                    assert (module != null);
                    List files = contributor.getDefaultConfigurationFiles(module, false);
                    String configName = StringUtil.defaultIfEmpty((String)SpringBootCustomizationDialog.this.getConfigFileName(), (String)defaultConfigName);
                    List configNameFiles = contributor.findApplicationConfigFiles(module, false, configName);
                    if (!configNameFiles.isEmpty()) {
                        SpringBootCustomizationDialog.this.foundConfigFilesByName = true;
                    }
                    files.addAll(configNameFiles);
                    LinkedHashSet<PsiFile> hashSet = new LinkedHashSet<PsiFile>();
                    ContainerUtil.addAll(hashSet, (Iterable)PsiUtilCore.toPsiFiles((PsiManager)psiManager, (Collection)files));
                    return hashSet;
                }
            };
            searchers.add(searcher);
        }
        searchers.add(new ConfigFileSearcher(this.myModule, this.myModule.getProject()){

            public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$8", "search"));
                }
                LinkedHashSet<PsiFile> hashSet = new LinkedHashSet<PsiFile>();
                ContainerUtil.addAll(hashSet, (Iterable)PsiUtilCore.toPsiFiles((PsiManager)psiManager, (Collection)SpringBootCustomizationDialog.this.myCustomConfigFiles));
                return hashSet;
            }
        });
        return searchers.toArray(new ConfigFileSearcher[searchers.size()]);
    }

    private String getConfigFileName() {
        return this.mySpringConfigNameTextField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.foundConfigFilesByName) {
            return new ValidationInfo("No configuration files matching pattern '" + this.getConfigFileName() + "' found", this.mySpringConfigNameTextField);
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "SpringBootCustomization";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Application Configuration Files", (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myTreePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setToolTipText("Uncheck to remove custom configuration files");
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("<html><code>spring.config.name</code>:</html>");
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(0, 2, 2, 1, 0, 1, 6, 1, null, null, null));
        this.myTextFieldPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, new Dimension(250, -1), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class SpringConfigNameAutoCompletionListProvider
    extends TextFieldWithAutoCompletionListProvider<SpringConfigNameProposal> {
        private SpringConfigNameAutoCompletionListProvider(List<SpringConfigNameProposal> variants) {
            super(variants);
        }

        @NotNull
        protected String getLookupString(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider", "getLookupString"));
            }
            String string = item.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider", "getLookupString"));
            }
            return string;
        }

        protected String getTypeText(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider", "getTypeText"));
            }
            return "(." + item.myFileType.getDefaultExtension() + ")";
        }

        @Nullable
        public String getAdvertisement() {
            return "Use (+) to add configuration files from custom location";
        }

        protected String getTailText(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider", "getTailText"));
            }
            List configFiles = item.myConfigFilesByName;
            StringBuilder tailText = new StringBuilder(" ");
            if (configFiles.size() > 1) {
                tailText.append("[Detected Profiles: ");
                SmartList profileNames = new SmartList();
                for (VirtualFile file : configFiles) {
                    String nameWithoutExtension = file.getNameWithoutExtension();
                    if (!StringUtil.containsChar((String)nameWithoutExtension, (char)'-')) continue;
                    profileNames.add(StringUtil.substringAfter((String)nameWithoutExtension, (String)"-"));
                }
                tailText.append(StringUtil.join((Collection)profileNames, (String)", "));
                tailText.append("] ");
            }
            return tailText.toString();
        }

        @Nullable
        protected Icon getIcon(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider", "getIcon"));
            }
            return item.myFileType.getIcon();
        }
    }

    private static class SpringConfigNameProposal {
        private final FileType myFileType;
        private final String myName;
        private final List<VirtualFile> myConfigFilesByName;

        private SpringConfigNameProposal(FileType fileType, String name, List<VirtualFile> configFilesByName) {
            this.myFileType = fileType;
            this.myName = name;
            this.myConfigFilesByName = configFilesByName;
        }
    }
}

