/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.boot.facet.SpringBootCustomizationDialog;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import icons.SpringBootApiIcons;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;

public class SpringBootFileSetEditorCustomization
extends SpringFileSetEditorCustomization {
    public static final Key<CustomSetting.BOOLEAN> NON_STRICT_SETTING = Key.create((String)"spring_boot_non_strict_conditional_eval");

    public boolean isApplicable(SpringFileSet fileSet) {
        return fileSet.isAutodetected() && fileSet.getId().startsWith("spring_boot_");
    }

    public List<SpringFileSetEditorCustomization.CustomConfigFileGroup> getCustomConfigFileGroups(SpringFileSet fileSet) {
        Module module = fileSet.getFacet().getModule();
        HashSet allContributorFiles = new HashSet();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            allContributorFiles.addAll(contributor.getConfigurationFiles(module, false));
        }
        LinkedHashSet<VirtualFilePointer> configFiles = new LinkedHashSet<VirtualFilePointer>();
        for (VirtualFilePointer pointer : fileSet.getFiles()) {
            VirtualFile file;
            if (!pointer.isValid() || (file = pointer.getFile()) == null || !allContributorFiles.contains(file)) continue;
            configFiles.add(pointer);
        }
        if (configFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SpringFileSetEditorCustomization.CustomConfigFileGroup("Configuration Files", SpringBootApiIcons.SpringBoot, configFiles));
    }

    public List<CustomSetting> getCustomSettings() {
        return ContainerUtil.newArrayList((Object[])new CustomSetting[]{new CustomSetting.BOOLEAN(NON_STRICT_SETTING, "Spring Boot: non-strict @Conditional evaluation", true), new CustomSetting.STRING(SpringBootModelConfigFileContributor.SPRING_CONFIG_NAME_CUSTOM_SETTING_ID, "Spring Boot: spring.config.name value", "application"), new CustomSetting.STRING(SpringBootModelConfigFileContributor.SPRING_CONFIG_CUSTOM_FILES_ID, "Spring Boot: custom config files location(s)", "")});
    }

    public AnAction[] getExtraActions() {
        return new AnAction[]{new CustomizeSpringBootAction()};
    }

    static class SpringBootCustomConfigFilesSettingPathMacroFilter
    extends PathMacroFilter {
        SpringBootCustomConfigFilesSettingPathMacroFilter() {
        }

        public boolean recursePathMacros(Attribute attribute) {
            if (SpringBootModelConfigFileContributor.SPRING_CONFIG_CUSTOM_FILES_ID.toString().equals(attribute.getName())) {
                Element parent = attribute.getParent();
                return "configuration".equals(parent.getName());
            }
            return false;
        }
    }

    private static class CustomizeSpringBootAction
    extends AnAction {
        private CustomizeSpringBootAction() {
            super("Customize Spring Boot...", "Customize Spring Boot autodetected context", SpringBootApiIcons.SpringBoot);
        }

        public void actionPerformed(AnActionEvent e) {
            SpringFileSet set = (SpringFileSet)DataManager.getInstance().loadFromDataContext(e.getDataContext(), SpringFileSetEditorCustomization.EXTRA_ACTION_FILESET);
            SpringBootCustomizationDialog customizationDialog = new SpringBootCustomizationDialog(e.getProject(), set);
            customizationDialog.show();
        }
    }
}

