/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootStartersExternalLibraryResolver
extends ExternalLibraryResolver {
    SpringBootStartersExternalLibraryResolver() {
    }

    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "resolveClass"));
        }
        if (isAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isAnnotation", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "resolveClass"));
        }
        if (contextModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "resolveClass"));
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)contextModule)) {
            return null;
        }
        if (isAnnotation == ThreeState.YES) {
            return SpringBootStartersExternalLibraryResolver.handleAnnotation(shortClassName, contextModule);
        }
        return SpringBootStartersExternalLibraryResolver.handleClass(shortClassName, contextModule);
    }

    @Nullable
    private static ExternalLibraryResolver.ExternalClassResolveResult handleClass(@NotNull String shortClassName, @NotNull Module contextModule) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "handleClass"));
        }
        if (contextModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "handleClass"));
        }
        if ("JdbcTemplate".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(contextModule, "org.springframework.jdbc.core.JdbcTemplate", "jdbc");
        }
        if ("DataSource".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(contextModule, "javax.sql.DataSource", "jdbc");
        }
        return null;
    }

    @Nullable
    private static ExternalLibraryResolver.ExternalClassResolveResult handleAnnotation(@NotNull String shortClassName, @NotNull Module module) {
        if (shortClassName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortClassName", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "handleAnnotation"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "handleAnnotation"));
        }
        if ("EnableBatchProcessing".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.batch.core.configuration.annotation.EnableBatchProcessing", "batch");
        }
        if ("EnableCaching".equals(shortClassName) && SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.cache.annotation.EnableCaching", "cache");
        }
        if ("EnableIntegration".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.integration.config.EnableIntegration", "integration");
        }
        if ("MessageEndpoint".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.integration.annotation.MessageEndpoint", "integration");
        }
        if ("Entity".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "javax.persistence.Entity", "data-jpa");
        }
        if ("RequestMapping".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.bind.annotation.RequestMapping", "web");
        }
        if ("RestController".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.bind.annotation.RestController", "web");
        }
        if ("EnableRabbit".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.amqp.rabbit.annotation.EnableRabbit", "amqp");
        }
        if ("EnableWebSecurity".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.security.config.annotation.web.configuration.EnableWebSecurity", "security");
        }
        if ("EnableGlobalMethodSecurity".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity", "security");
        }
        if ("Test".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.junit.Test", "test");
        }
        if ("NotNull".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "javax.validation.constraints.NotNull", "validation");
        }
        if ("EnableWebSocket".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.socket.config.annotation.EnableWebSocket", "websocket");
        }
        if ("EnableWebSocketMessageBroker".equals(shortClassName)) {
            return SpringBootStartersExternalLibraryResolver.createStarterResult(module, "org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker", "websocket");
        }
        return null;
    }

    @NotNull
    private static ExternalLibraryResolver.ExternalClassResolveResult createStarterResult(@NotNull Module contextModule, String qualifiedClassName, String starterSuffix) {
        if (contextModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextModule", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "createStarterResult"));
        }
        String springBootVersion = SpringBootLibraryUtil.getVersionFromJar((Module)contextModule);
        ExternalLibraryDescriptor libraryDescriptor = new ExternalLibraryDescriptor("org.springframework.boot", "spring-boot-starter-" + starterSuffix, springBootVersion, springBootVersion){

            @NotNull
            public List<String> getLibraryClassesRoots() {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver$1", "getLibraryClassesRoots"));
                }
                return list;
            }
        };
        ExternalLibraryResolver.ExternalClassResolveResult externalClassResolveResult = new ExternalLibraryResolver.ExternalClassResolveResult(qualifiedClassName, libraryDescriptor);
        if (externalClassResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/library/SpringBootStartersExternalLibraryResolver", "createStarterResult"));
        }
        return externalClassResolveResult;
    }
}

