/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureAfter;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureBefore;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureOrder;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class AutoConfigClassSorter {
    public static final Comparator<PsiClass> CLASS_NAME_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getQualifiedName(), (String)o2.getQualifiedName(), (boolean)false);
    private static final Comparator<PsiClass> AUTOCONFIGURE_ORDER_COMPARATOR = (o1, o2) -> {
        int order1 = AutoConfigClassSorter.getAutoConfigureOrderValue(o1);
        int order2 = AutoConfigClassSorter.getAutoConfigureOrderValue(o2);
        return Comparing.compare((int)order1, (int)order2);
    };
    private final List<PsiClass> allConfigs;

    private static int getAutoConfigureOrderValue(PsiClass psiClass) {
        AutoConfigureOrder autoConfigureOrder = (AutoConfigureOrder)AutoConfigureOrder.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (autoConfigureOrder == null) {
            return AutoConfigureOrder.DEFAULT_VALUE;
        }
        return (Integer)ObjectUtils.notNull((Object)autoConfigureOrder.getValue(), (Object)AutoConfigureOrder.DEFAULT_VALUE);
    }

    AutoConfigClassSorter(List<PsiClass> allConfigs) {
        this.allConfigs = allConfigs;
    }

    List<PsiClass> getSortedConfigs() {
        ArrayList<PsiClass> configs = new ArrayList<PsiClass>(this.allConfigs);
        Collections.sort(configs, CLASS_NAME_COMPARATOR);
        Collections.sort(configs, AUTOCONFIGURE_ORDER_COMPARATOR);
        return this.sortByAutoConfigureAfterBefore(configs);
    }

    private List<PsiClass> sortByAutoConfigureAfterBefore(List<PsiClass> configs) {
        ArrayList<PsiClass> toSort = new ArrayList<PsiClass>(configs);
        LinkedHashSet<PsiClass> sorted = new LinkedHashSet<PsiClass>();
        LinkedHashSet<PsiClass> processing = new LinkedHashSet<PsiClass>();
        while (!toSort.isEmpty()) {
            this.doSortByAfterAnnotation(toSort, sorted, processing, null);
        }
        return new ArrayList<PsiClass>(sorted);
    }

    private void doSortByAfterAnnotation(List<PsiClass> toSort, Set<PsiClass> sorted, Set<PsiClass> processing, PsiClass current) {
        if (current == null) {
            current = toSort.remove(0);
        }
        processing.add(current);
        for (PsiClass after : this.getClassesRequestedAfter(current)) {
            if (sorted.contains(after) || !toSort.contains(after)) continue;
            this.doSortByAfterAnnotation(toSort, sorted, processing, after);
        }
        processing.remove(current);
        sorted.add(current);
    }

    private Set<PsiClass> getClassesRequestedAfter(PsiClass config) {
        LinkedHashSet<PsiClass> rtn = new LinkedHashSet<PsiClass>();
        AutoConfigureAfter autoConfigureAfter = (AutoConfigureAfter)AutoConfigureAfter.META.getJamElement((PsiModifierListOwner)config);
        if (autoConfigureAfter != null) {
            rtn.addAll(autoConfigureAfter.getClasses());
        }
        for (PsiClass all : this.allConfigs) {
            AutoConfigureBefore autoConfigureBefore = (AutoConfigureBefore)AutoConfigureBefore.META.getJamElement((PsiModifierListOwner)config);
            if (autoConfigureBefore == null || !autoConfigureBefore.getClasses().contains(config)) continue;
            rtn.add(all);
        }
        return rtn;
    }
}

