/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AutoConfigurationModelBase
extends LocalAnnotationModel {
    private final LocalAnnotationModel myLocalAnnotationModel;
    private final PsiClass myConfigClass;

    protected AutoConfigurationModelBase(LocalAnnotationModel localAnnotationModel, PsiClass configClass) {
        this.myLocalAnnotationModel = localAnnotationModel;
        this.myConfigClass = configClass;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "setActiveProfiles"));
        }
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return Collections.emptySet();
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myConfigClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "getConfig"));
        }
        return psiClass;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        List<PsiClass> autoConfigClasses = this.getAutoConfigClasses();
        LinkedHashSet autoConfigModels = ContainerUtil.newLinkedHashSet();
        autoConfigClasses.forEach(autoConfigClass -> this.processConfigurationClass(autoConfigModels, (PsiClass)autoConfigClass));
        LinkedHashSet linkedHashSet = autoConfigModels;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "getDependentLocalModels"));
        }
        return linkedHashSet;
    }

    private void processConfigurationClass(Set<Pair<LocalModel, LocalModelDependency>> autoConfigModels, PsiClass autoConfigClass) {
        AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(this.getModule(), autoConfigClass, this.myLocalAnnotationModel.getActiveProfiles());
        if (!evaluator.isActive()) {
            return;
        }
        LocalAnnotationModel autoConfigModel = SpringManager.getInstance((Project)this.myConfigClass.getProject()).getLocalSpringModel(autoConfigClass, this.getModule());
        if (autoConfigModel == null) {
            return;
        }
        autoConfigModel.disableEvaluatingInnerConfigurationClasses();
        LocalModelDependency dependency = LocalModelDependency.create((String)("Auto-configuration @" + this.myConfigClass.getQualifiedName()), (LocalModelDependencyType)this.getModelDependencyType(), (PsiElement)autoConfigClass.getNavigationElement());
        autoConfigModels.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)autoConfigModel, (Object)dependency));
        for (PsiClass innerConfig : autoConfigClass.getInnerClasses()) {
            if (!innerConfig.hasModifierProperty("static") || JamService.getJamService((Project)this.getModule().getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)innerConfig) == null) continue;
            this.processConfigurationClass(autoConfigModels, innerConfig);
        }
    }

    protected LocalAnnotationModel getLocalAnnotationModel() {
        return this.myLocalAnnotationModel;
    }

    @NotNull
    protected abstract List<PsiClass> getAutoConfigClasses();

    @NotNull
    protected abstract LocalModelDependencyType getModelDependencyType();

    @NotNull
    public Module getModule() {
        Module module = this.myLocalAnnotationModel.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = this.myLocalAnnotationModel.getAllProfiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "getAllProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set set = this.myLocalAnnotationModel.getConfigFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "getConfigFiles"));
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/boot/model/autoconfigure/AutoConfigurationModelBase", "hasConfigFile"));
        }
        return this.myLocalAnnotationModel.hasConfigFile(configFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoConfigurationModelBase model = (AutoConfigurationModelBase)((Object)o);
        if (!this.myConfigClass.equals(model.myConfigClass)) {
            return false;
        }
        return this.myLocalAnnotationModel.equals(model.myLocalAnnotationModel);
    }

    public int hashCode() {
        int result = this.myConfigClass.hashCode();
        result = 31 * result + this.myLocalAnnotationModel.hashCode();
        return result;
    }
}

