/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing.jam.custom.providers;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutoConfiguredImplicitContextsProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(@Nullable Module module, @NotNull ContextConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider", "getModels"));
        }
        if (module == null) {
            List<CommonSpringModel> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider", "getModels"));
            }
            return list;
        }
        List models = ContainerUtil.newSmartList();
        for (String anno : SpringAutoConfiguredImplicitContextsProvider.getAutoConfiguredTestAnnotations(module)) {
            if (!SpringAutoConfiguredImplicitContextsProvider.isAnnotated((ContextConfiguration)configuration, (Module)module, (String)anno)) continue;
            for (PsiClass registeredClass : SpringSpiManager.getInstance((Module)module).getClassesListValue(true, anno)) {
                ContainerUtil.addIfNotNull((Collection)models, (Object)SpringManager.getInstance((Project)module.getProject()).getLocalSpringModel(registeredClass, module));
            }
        }
        List list = models;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider", "getModels"));
        }
        return list;
    }

    private static Collection<String> getAutoConfiguredTestAnnotations(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider", "getAutoConfiguredTestAnnotations"));
        }
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider", "lambda$getAutoConfiguredTestAnnotations$0"));
            }
            List annotations = ContainerUtil.newSmartList();
            List files = SpringSpiManager.getInstance((Module)module).getSpringFactoriesFiles(true);
            for (PropertiesFileImpl file : files) {
                for (IProperty property : file.getProperties()) {
                    PsiClass keyClass;
                    String key = property.getKey();
                    if (key == null || (keyClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(key, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true))) == null || !keyClass.isAnnotationType()) continue;
                    annotations.add(key);
                }
            }
            return CachedValueProvider.Result.create((Object)annotations, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }
}

