/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command.mq;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgQImportCommand {
    @NotNull
    private final HgRepository myRepository;

    public HgQImportCommand(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/command/mq/HgQImportCommand", "<init>"));
        }
        this.myRepository = repository;
    }

    public void execute(@NotNull String startRevisionNumber) {
        if (startRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevisionNumber", "org/zmlx/hg4idea/command/mq/HgQImportCommand", "execute"));
        }
        HgUtil.executeOnPooledThread(() -> {
            if (startRevisionNumber == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevisionNumber", "org/zmlx/hg4idea/command/mq/HgQImportCommand", "lambda$execute$0"));
            }
            this.executeInCurrentThread(startRevisionNumber);
        }, (Disposable)this.myRepository.getProject());
    }

    public void executeInCurrentThread(@NotNull String startRevisionNumber) {
        if (startRevisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startRevisionNumber", "org/zmlx/hg4idea/command/mq/HgQImportCommand", "executeInCurrentThread"));
        }
        Project project = this.myRepository.getProject();
        String lastRevisionName = this.myRepository.getMQAppliedPatches().isEmpty() ? "tip" : "qparent";
        ArrayList arguments = ContainerUtil.newArrayList((Object[])new String[]{"--rev", startRevisionNumber + ":" + lastRevisionName});
        HgCommandResult result = new HgCommandExecutor(project).executeInCurrentThread(this.myRepository.getRoot(), "qimport", arguments);
        if (HgErrorUtil.hasErrorsInCommandExecution(result)) {
            new HgCommandResultNotifier(project).notifyError(result, "Import failed", "Import revision from " + startRevisionNumber + " to qparent failed");
        }
        this.myRepository.update();
    }
}

