/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.jsp.JspBundle;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspCommentIntention
extends AbstractIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intentions/JspCommentIntention", "isAvailable"));
        }
        XmlComment comment = JspCommentIntention.getXmlComment(editor, file);
        return comment != null && XmlUtil.getCommentText((XmlComment)comment) != null;
    }

    @Nullable
    private static XmlComment getXmlComment(Editor editor, PsiFile file) {
        PsiFile psiFile;
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        if (jspFile != null && (psiFile = jspFile.getBaseLanguageRoot()).getLanguage().equals(HTMLLanguage.INSTANCE)) {
            PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
            return (XmlComment)PsiTreeUtil.getParentOfType((PsiElement)element, XmlComment.class, (boolean)false);
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JspBundle.message("replace.with.jsp.comment.intention", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intentions/JspCommentIntention", "getText"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, final Editor editor, PsiFile file) throws IncorrectOperationException {
        String text;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intentions/JspCommentIntention", "invoke"));
        }
        final XmlComment comment = JspCommentIntention.getXmlComment(editor, file);
        if (comment != null && (text = XmlUtil.getCommentText((XmlComment)comment)) != null) {
            new WriteCommandAction.Simple(project, new PsiFile[]{file}){

                protected void run() throws Throwable {
                    TextRange range = comment.getTextRange();
                    editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("<%--" + text + "--%>"));
                }
            }.execute();
        }
    }
}

