/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspSpiUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.lang.UrlClassLoader;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UserClassLoader {
    private final boolean myIncludeModuleOutput;
    private final Key<CachedValue<CachedInfo>> myKey;
    private static final UserClassLoader LIBRARIES_CACHE = new UserClassLoader("libraries class loader", false){

        @Override
        protected Object[] getDependencies(Module module) {
            return new Object[]{ProjectRootManager.getInstance((Project)module.getProject())};
        }
    };
    private static final UserClassLoader ALL_CLASSPATH_CACHE = new UserClassLoader("all classpath class loader", true){

        @Override
        protected Object[] getDependencies(Module module) {
            return new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
        }
    };

    private CachedValueProvider<CachedInfo> createProvider(final @NotNull Module module, final @Nullable PsiFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsp/impl/UserClassLoader", "createProvider"));
        }
        return new CachedValueProvider<CachedInfo>(){

            public CachedValueProvider.Result<CachedInfo> compute() {
                List urls = JspSpiUtil.buildUrls((VirtualFile)(context == null ? null : context.getVirtualFile()), (Module)module, (boolean)UserClassLoader.this.myIncludeModuleOutput);
                CachedInfo cachedInfo = new CachedInfo((ClassLoader)UrlClassLoader.build().urls(urls).parent(this.getClass().getClassLoader()).allowUnescaped().noPreload().get());
                return new CachedValueProvider.Result((Object)cachedInfo, UserClassLoader.this.getDependencies(module));
            }
        };
    }

    public UserClassLoader(String keyName, boolean includeModuleOutput) {
        this.myIncludeModuleOutput = includeModuleOutput;
        this.myKey = Key.create((String)keyName);
    }

    protected abstract Object[] getDependencies(Module var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Class<?> loadCachedClass(String className, @NotNull Module module, @Nullable PsiFile context) {
        CachedValue cachedValue;
        Module dataHolder;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsp/impl/UserClassLoader", "loadCachedClass"));
        }
        Module module2 = dataHolder = context == null ? module : context;
        synchronized (module2) {
            cachedValue = (CachedValue)dataHolder.getUserData(this.myKey);
            if (cachedValue == null) {
                CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)module.getProject());
                cachedValue = cachedValuesManager.createCachedValue(this.createProvider(module, context), false);
                dataHolder.putUserData(this.myKey, (Object)cachedValue);
            }
        }
        CachedInfo cachedInfo = (CachedInfo)cachedValue.getValue();
        assert (cachedInfo != null);
        return cachedInfo.loadClass(className);
    }

    @Nullable
    public static Class loadClass(String className, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsp/impl/UserClassLoader", "loadClass"));
        }
        return UserClassLoader.loadClass(className, module, null);
    }

    @Nullable
    public static Class loadClass(String className, @NotNull Module module, @Nullable PsiFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsp/impl/UserClassLoader", "loadClass"));
        }
        Project project = module.getProject();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className.replace('$', '.'), GlobalSearchScope.allScope((Project)project));
        if (psiClass != null) {
            Class<?> aClass;
            VirtualFile file = psiClass.getContainingFile().getVirtualFile();
            assert (file != null);
            if (file.getFileType() == StdFileTypes.CLASS && ProjectRootManager.getInstance((Project)project).getFileIndex().isLibraryClassFile(file) && (aClass = LIBRARIES_CACHE.loadCachedClass(className, module, context)) != null) {
                return aClass;
            }
            return ALL_CLASSPATH_CACHE.loadCachedClass(className, module, context);
        }
        return null;
    }

    private static class CachedInfo {
        private final Map<String, Class<?>> classes;

        CachedInfo(final ClassLoader classLoader) {
            this.classes = new FactoryMap<String, Class<?>>(){

                protected Class<?> create(String className) {
                    try {
                        return classLoader.loadClass(className);
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            };
        }

        Class<?> loadClass(String className) {
            return this.classes.get(className);
        }
    }
}

