/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el.impl;

import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CommonReferenceProviderTypes;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ClassFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.ElementFilterBase;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELElementProcessor;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.jsp.el.impl.ElVariablesProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspCommentImpl;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.xml.XmlNSDescriptor;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspElVariablesProvider
extends ElVariablesProvider {
    public static final NotNullFunction<XmlTag, String> DEFAULT_JSP_VAR_TYPE_PROVIDER = new ConstantFunction((Object)"java.lang.Object");
    private static final Key<CachedValue<Map<String, JspImplicitVariable>>> EL_IMPLICIT_VARS_MAP = Key.create((String)"el implicit vars");
    private static final ELResolveUtil.VariableInfoData ourData = new ELResolveUtil.VariableInfoData(EL_IMPLICIT_VARS_MAP);
    @NonNls
    private static final String ELVAR = "@elvar";
    @NonNls
    private static final Pattern ourVarCommentAnnotationPattern;

    @Override
    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder expressionHolder, @NotNull ELElementProcessor processor) {
        PsiFile containingFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/el/impl/JspElVariablesProvider", "processImplicitVariables"));
        }
        if (expressionHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionHolder", "com/intellij/psi/impl/source/jsp/el/impl/JspElVariablesProvider", "processImplicitVariables"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/el/impl/JspElVariablesProvider", "processImplicitVariables"));
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        PsiFile psiFile = containingFile = host == null ? expressionHolder.getContainingFile() : host.getContainingFile();
        if (!(containingFile instanceof JspFile)) {
            return true;
        }
        XmlTag tag = ELResolveUtil.getParentTagToStartResolving((PsiElement)(host != null ? host : element), expressionHolder);
        if (tag != null) {
            for (String namespace : tag.knownNamespaces()) {
                String prefixByNamespace;
                XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(namespace, true);
                if (!(nsDescriptor instanceof TldDescriptor) || ((TldDescriptor)nsDescriptor).getFunctionsCount() <= 0 || !StringUtil.isNotEmpty((String)(prefixByNamespace = tag.getPrefixByNamespace(namespace))) || processor.processNSPrefix(prefixByNamespace)) continue;
                return false;
            }
        }
        if (!ELResolveUtil.walkFromContext(tag, processor, DEFAULT_JSP_VAR_TYPE_PROVIDER, (PsiElement)expressionHolder)) {
            return false;
        }
        for (JspImplicitVariable implicitVariable : JspElVariablesProvider.createOrGetPredefinedVariablesMap(containingFile).values()) {
            if (processor.processVariable((PsiVariable)implicitVariable)) continue;
            return false;
        }
        return true;
    }

    private static Map<String, JspImplicitVariable> createOrGetPredefinedVariablesMap(PsiFile file) {
        return ELResolveUtil.createOrGetPredefinedVariablesMapImpl(file, ourData);
    }

    static void collectVariablesFromFile(final JspFile file, final List<JspImplicitVariable> result) {
        PsiClass javaClass = file.getJavaClass();
        if (javaClass == null) {
            return;
        }
        javaClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiType type;
                PsiExpression[] psiExpressions;
                String methodQualifierText;
                PsiExpression methodQualifier;
                super.visitMethodCallExpression(expression);
                PsiReferenceExpression methodExpression = expression.getMethodExpression();
                if ("setAttribute".equals(methodExpression.getReferenceName()) && (methodQualifier = methodExpression.getQualifierExpression()) != null && ("request".equals(methodQualifierText = methodQualifier.getText()) || "pageContext".equals(methodQualifierText) || "session".equals(methodQualifierText) || "application".equals(methodQualifierText)) && (psiExpressions = expression.getArgumentList().getExpressions()).length == 2 && psiExpressions[0] instanceof PsiLiteralExpression && (type = psiExpressions[1].getType()) != null) {
                    result.add(new JspImplicitVariableImpl((PsiElement)file, StringUtil.unquoteString((String)psiExpressions[0].getText()), type, (PsiElement)psiExpressions[0], "NESTED"));
                }
            }
        });
    }

    static void addVarsFromComments(final XmlTag tag, final List<JspImplicitVariable> resultVars) {
        tag.acceptChildren((PsiElementVisitor)new XmlElementVisitor(){

            public void visitXmlComment(XmlComment comment) {
                IElementType tokenType = comment.getTokenType();
                boolean jspxComment = false;
                if (tokenType == JspTokenType.JSP_COMMENT || tokenType == XmlElementType.XML_COMMENT && (jspxComment = tag.getLanguage() == StdLanguages.JSPX)) {
                    Matcher matcher;
                    String s = JspElVariablesProvider.getTextToMatch(comment.getText(), jspxComment);
                    if (s.startsWith(JspElVariablesProvider.ELVAR) && (matcher = ourVarCommentAnnotationPattern.matcher(s)).matches()) {
                        resultVars.add(new JspImplicitVariableImpl((PsiElement)tag, matcher.group(1), PsiImplUtil.buildTypeFromTypeString((String)matcher.group(2), (PsiElement)comment, (PsiFile)tag.getContainingFile()), (PsiElement)comment, "NESTED"));
                    }
                } else {
                    comment.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
    }

    private static String getTextToMatch(String s, boolean jspxComment) {
        String commentEnd;
        String commentStart = jspxComment ? "<!--" : "<%--";
        String string = commentEnd = jspxComment ? "-->" : "--%>";
        if (s.length() < commentStart.length() + commentEnd.length()) {
            return s;
        }
        s = s.substring(commentStart.length(), s.length() - commentEnd.length());
        return s;
    }

    public static PsiReference[] getReferencesFromComment(XmlComment comment) {
        String s = comment.getText();
        int fromIndex = 4;
        if (s.indexOf(ELVAR, 4) == -1) {
            return PsiReference.EMPTY_ARRAY;
        }
        String textToMatch = JspElVariablesProvider.getTextToMatch(s, !(comment instanceof JspCommentImpl));
        Matcher matcher = ourVarCommentAnnotationPattern.matcher(textToMatch);
        if (matcher.matches()) {
            JavaClassReferenceProvider provider = (JavaClassReferenceProvider)CommonReferenceProviderTypes.getInstance().getClassReferenceProvider();
            Object[] classReferences = provider.getReferencesByString(matcher.group(2), (PsiElement)comment, matcher.start(2) + 4);
            MyCommentReference selfReference = new MyCommentReference(comment, new TextRange(matcher.start(1) + 4, matcher.end(1) + 4));
            return (PsiReference[])ArrayUtil.append((Object[])classReferences, (Object)((Object)selfReference), PsiReference.class);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static ElementFilter getImplicitVarDescriptor() {
        return new AndFilter((ElementFilter)new ClassFilter(XmlComment.class), (ElementFilter)new ElementFilterBase<XmlComment>(XmlComment.class){

            protected boolean isElementAcceptable(@NotNull XmlComment element, PsiElement context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/el/impl/JspElVariablesProvider$3", "isElementAcceptable"));
                }
                return element.getText().contains(JspElVariablesProvider.ELVAR);
            }
        });
    }

    public static String getImplicitVariableName(XmlComment comment) {
        String textToMatch = JspElVariablesProvider.getTextToMatch(comment.getText(), !(comment instanceof JspCommentImpl));
        Matcher matcher = ourVarCommentAnnotationPattern.matcher(textToMatch);
        return matcher.matches() ? matcher.group(1) : null;
    }

    static {
        ourData.add("pageScope", "java.lang.Object", true);
        ourData.add("requestScope", "java.lang.Object", true);
        ourData.add("sessionScope", "java.lang.Object", true);
        ourData.add("applicationScope", "java.lang.Object", true);
        ourData.add("param", "java.lang.String", true);
        ourData.add("paramValues", "java.lang.String[]", true);
        ourData.add("header", "java.lang.String", true);
        ourData.add("headerValues", "java.lang.String[]", true);
        ourData.add("cookie", "javax.servlet.http.Cookie", true);
        ourData.add("initParam", "java.lang.String", true);
        ourVarCommentAnnotationPattern = Pattern.compile("@elvariable id=\"(.+)\" type=\"(.*)\"");
    }

    private static class MyCommentReference
    extends BasicAttributeValueReference {
        public MyCommentReference(XmlComment comment, TextRange textRange) {
            super((PsiElement)comment, textRange);
        }

        @Nullable
        public PsiElement resolve() {
            return this.getElement();
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/el/impl/JspElVariablesProvider$MyCommentReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        public boolean isSoft() {
            return true;
        }
    }
}

