/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.settings;

import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uml.settings.tree.DiagramSettingsTree;
import com.intellij.uml.settings.tree.DiagramSettingsTreeNode;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTree;

public class DiagramSettingsForm {
    private final DiagramConfiguration myInitialConfiguration;
    private JComboBox layouts;
    private JCheckBox fitContentAfterLayout;
    private JPanel component;
    private JCheckBox myRelayout;
    private JComboBox scopes;
    private JTabbedPane myUmlProvidersTabs;
    private Tree myTree;
    private boolean changed;
    private final DiagramConfiguration myConfiguration;

    public DiagramSettingsForm(DiagramConfiguration initialConfiguration) {
        this.myInitialConfiguration = initialConfiguration;
        this.$$$setupUI$$$();
        this.myConfiguration = (DiagramConfiguration)XmlSerializerUtil.createCopy((Object)this.myInitialConfiguration);
        ActionListener notifier = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiagramSettingsForm.this.update();
                DiagramSettingsForm.this.changed = true;
            }
        };
        this.initUI(this.myInitialConfiguration);
        DiagramSettingsForm.installListener(this.component, notifier);
    }

    private void createUIComponents() {
        this.myTree = new DiagramSettingsTree(this.myInitialConfiguration);
        this.myTree.setRootVisible(false);
        TreeUtil.expandAll((JTree)this.myTree);
    }

    private static void installListener(JComponent component, ActionListener listener) {
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).addActionListener(listener);
            return;
        }
        if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(listener);
            return;
        }
        for (Component comp : component.getComponents()) {
            if (!(comp instanceof JComponent)) continue;
            DiagramSettingsForm.installListener((JComponent)comp, listener);
        }
    }

    public void initUI(DiagramConfiguration conf) {
        for (DiagramLayout layout : DiagramLayout.values()) {
            if (layout == DiagramLayout.TREE) continue;
            this.layouts.addItem(layout.getPresentableName());
        }
        if (conf.layout == null) {
            conf.layout = DiagramLayout.HIERARCHIC_GROUP;
        }
    }

    private void fillValues(DiagramConfiguration conf) {
        this.fitContentAfterLayout.setSelected(conf.fitContentAfterLayout);
        this.myRelayout.setSelected(conf.relayoutOnNewElements);
        this.layouts.setSelectedItem(conf.layout.getPresentableName());
        this.scopes.setSelectedItem(conf.defaultScope);
    }

    public JPanel getJComponent() {
        return this.component;
    }

    public void update() {
        this.myConfiguration.fitContentAfterLayout = this.fitContentAfterLayout.isSelected();
        this.myConfiguration.layout = DiagramLayout.fromString((Object)this.layouts.getSelectedItem());
        this.myConfiguration.relayoutOnNewElements = this.myRelayout.isSelected();
        this.myConfiguration.defaultScope = this.scopes.getSelectedItem().toString();
    }

    public boolean changed() {
        return this.changed || ((DiagramSettingsTreeNode)((Object)this.myTree.getModel().getRoot())).isChanged();
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public void apply() {
        XmlSerializerUtil.copyBean((Object)this.myConfiguration, (Object)this.myInitialConfiguration);
        ((DiagramSettingsTree)this.myTree).apply(this.myInitialConfiguration);
        this.setChanged(false);
    }

    public void reset() {
        this.fillValues(this.myInitialConfiguration);
        ((DiagramSettingsTree)this.myTree).reset();
        this.setChanged(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.component = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.fitContentAfterLayout = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("resources/messages/UmlBundle").getString("fit.content.after.layout"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRelayout = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("resources/messages/UmlBundle").getString("do.relayout.when.new.elements.were.added"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("resources/messages/UmlBundle").getString("default.layout"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.layouts = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("resources/messages/UmlBundle").getString("default.scope"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.scopes = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("All");
        defaultComboBoxModel2.addElement("Project Files");
        defaultComboBoxModel2.addElement("Non-Project Files");
        defaultComboBoxModel2.addElement("Production");
        defaultComboBoxModel2.addElement("Tests");
        jComboBox.setModel(defaultComboBoxModel2);
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, "Center");
        Tree tree = this.myTree;
        jBScrollPane.setViewportView((Component)tree);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Select categories that will be enabled by default every time diagram appears");
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.component;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

