/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.xml.xmlbeans;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.utils.ui.GenerateJavaCodeDialogBase;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import com.intellij.ws.xml.xmlbeans.GenerateJavaFromXmlBeansSchemasAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenerateJavaFromXmlBeansSchemasDialog
extends GenerateJavaCodeDialogBase {
    private JCheckBox addLibs;
    private JPanel panel;
    private ComboboxWithBrowseButton outputFileName;
    private JLabel outputPathesText;
    private ComboboxWithBrowseButton generateFromUrl;
    private JLabel generateFromUrlText;
    private boolean mySelectedJarFile;

    public GenerateJavaFromXmlBeansSchemasDialog(Project _project, @Nullable GenerateJavaFromXmlBeansSchemasDialog previousDialog) {
        super(_project);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("generate.java.code.from.xmlbeans.schemas.dialog.title", objectArray));
        this.configureBrowseButton(this.myProject, this.generateFromUrl, new String[]{"xsd", "wsdl"}, "Select Xml Schema / Wsdl File For Generation");
        this.configureBrowseButton(this.myProject, this.outputFileName, new String[]{"jar"}, "Select JAR File To Overwrite");
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        List<String> lastUrls = instance.getLastXmlBeansUrls();
        this.configureComboBox(this.getUrl().getComboBox(), lastUrls);
        this.doInitFor(this.generateFromUrlText, this.getUrl().getComboBox(), 'c');
        this.doInitFor(this.outputPathesText, this.outputFileName.getComboBox(), 'o');
        if (previousDialog != null) {
            this.outputFileName.getComboBox().setSelectedItem(previousDialog.outputFileName.getComboBox().getSelectedItem());
        } else {
            this.outputFileName.getComboBox().setSelectedItem("types.jar");
        }
        this.init();
    }

    @Override
    protected void initVirtualFile(VirtualFile virtualFile) {
        if ("jar".equals(virtualFile.getExtension())) {
            this.mySelectedJarFile = true;
            this.outputFileName.getComboBox().setSelectedItem(VfsUtilCore.fixIDEAUrl((String)virtualFile.getUrl()));
        } else {
            super.initVirtualFile(virtualFile);
        }
    }

    @Override
    protected boolean isAcceptableFile(VirtualFile virtualFile) {
        if (virtualFile != null) {
            return GenerateJavaFromXmlBeansSchemasAction.isAcceptableFileForJavaFromXmlBeans(virtualFile);
        }
        return false;
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        ValidationInfo validationResult = GenerateJavaFromXmlBeansSchemasDialog.checkXmlBeansPathSet();
        if (validationResult != null) {
            return validationResult;
        }
        return super.doValidate(_data);
    }

    @Override
    protected ValidationInfo doValidateWithData(GenerateJavaCodeDialogBase.MyValidationData data) {
        ValidationInfo validationResult = super.doValidateWithData(data);
        if (validationResult != null) {
            return validationResult;
        }
        MyValidationData mydata = (MyValidationData)data;
        if (mydata.outputFileNameValue == null || !mydata.outputFileNameValue.endsWith(".jar")) {
            return new ValidationInfo("Invalid output JAR file name", (JComponent)this.outputFileName.getComboBox());
        }
        return (ValidationInfo)ReadAction.compute(() -> {
            VirtualFile relativeFile = UriUtil.findRelativeFile((String)VfsUtilCore.fixURLforIDEA((String)((String)data.currentUrl)), null);
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(relativeFile);
            if (psiFile instanceof XmlFile) {
                XmlFile file = (XmlFile)psiFile;
                XmlTag rootTag = file.getDocument().getRootTag();
                if (rootTag != null) {
                    String xmlnsValue = rootTag.getAttributeValue("xmlns");
                    String targetNsValue = rootTag.getAttributeValue("targetNamespace");
                    return null;
                }
                return new ValidationInfo("No root tag", (JComponent)this.getUrl());
            }
            return null;
        });
    }

    @Override
    protected GenerateJavaCodeDialogBase.MyValidationData createValidationData() {
        return new MyValidationData();
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("GenerateJavaFromXmlBeansSchemas.html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/xml/xmlbeans/GenerateJavaFromXmlBeansSchemasDialog", "getHelpId"));
        }
        return "GenerateJavaFromXmlBeansSchemas.html";
    }

    protected JComponent createCenterPanel() {
        return this.panel;
    }

    @Override
    protected JCheckBox getAddLibs() {
        return this.addLibs;
    }

    @Override
    protected EditorComboBox getPackagePrefix() {
        return null;
    }

    @Override
    protected JComboBox getOutputPaths() {
        return null;
    }

    @Override
    protected JLabel getOutputPathsText() {
        return this.outputPathesText;
    }

    @Override
    protected JLabel getPackagePrefixText() {
        return null;
    }

    @Override
    protected ComboboxWithBrowseButton getUrl() {
        return this.generateFromUrl;
    }

    static ValidationInfo checkXmlBeansPathSet() {
        if (WebServicesPluginSettings.getInstance().getXmlBeansPath() == null) {
            return new ValidationInfo("Please, specify XmlBeans Path in plugin settings", null);
        }
        return null;
    }

    public String getOutputFileName() {
        return (String)this.outputFileName.getComboBox().getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboboxWithBrowseButton comboboxWithBrowseButton;
        ComboboxWithBrowseButton comboboxWithBrowseButton2;
        JLabel jLabel;
        JLabel jLabel2;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(1, 1, 1, 1), -1, -1, false, false));
        this.addLibs = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 3, 2, 3));
        jCheckBox.setSelected(true);
        jCheckBox.setLabel("Add necessary libraries in order for generated code to compile and work");
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.addrequiredlibs.tooltip"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.addrequiredlibs.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.generateFromUrlText = jLabel2 = new JLabel();
        jLabel2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xmlbeans.url.tooltip"));
        jLabel2.setText("Schema path:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPathesText = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.outputpath.tooltip"));
        jLabel.setText("Output path:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputFileName = comboboxWithBrowseButton2 = new ComboboxWithBrowseButton();
        comboboxWithBrowseButton2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.outputpath.tooltip"));
        jPanel.add((Component)comboboxWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.generateFromUrl = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
        comboboxWithBrowseButton.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("xmlbeans.url.tooltip"));
        jPanel.add((Component)comboboxWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    class MyValidationData
    extends GenerateJavaCodeDialogBase.MyValidationData {
        String outputFileNameValue;

        MyValidationData() {
        }

        @Override
        protected void doAcquire() {
            super.doAcquire();
            this.outputFileNameValue = (String)GenerateJavaFromXmlBeansSchemasDialog.this.outputFileName.getComboBox().getEditor().getItem();
        }
    }
}

