/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.editor;

import com.intellij.lang.BracePair;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssBraceMatcher;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;

public class LessBraceMatcher
extends CssBraceMatcher {
    private static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair(CssElementTypes.CSS_LPAREN, CssElementTypes.CSS_RPAREN, false), new BracePair(CssElementTypes.CSS_LBRACKET, CssElementTypes.CSS_RBRACKET, false), new BracePair(CssElementTypes.CSS_LBRACE, CssElementTypes.CSS_RBRACE, true), new BracePair(LESSTokenTypes.INTERPOLATION_PREFIX, LESSTokenTypes.INTERPOLATION_SUFFIX, true)};

    @NotNull
    public BracePair[] getPairs() {
        if (BRACE_PAIRS == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/editor/LessBraceMatcher", "getPairs"));
        }
        return BRACE_PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType type) {
        if (lbraceType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "org/jetbrains/plugins/less/editor/LessBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return super.isPairedBracesAllowedBeforeType(lbraceType, type) || LESSTokenTypes.COMMENT == type || LESSTokenTypes.INTERPOLATION_SUFFIX == type;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

