/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.messages.spring;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.thymeleaf.lang.support.ThymeleafBundleProvider;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafSpringBundleProvider
extends ThymeleafBundleProvider {
    @Override
    @NotNull
    public Collection<PropertiesFile> getPropertiesFile(@NotNull PsiElement contextElement) {
        Module module;
        PsiFile containingFile;
        PsiElement context;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getPropertiesFile"));
        }
        ArrayList propertiesFiles = ContainerUtil.newArrayList();
        PsiFile thFile = contextElement.getContainingFile();
        if (thFile != null && (context = thFile.getContext()) != null && (containingFile = context.getContainingFile()) != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile)) != null) {
            SpringModel model = SpringManager.getInstance((Project)module.getProject()).getCombinedModel(module);
            List<SpringBeanPointer> beans = ThymeleafSpringBundleProvider.getBundleMessageSourceBeans(module, model);
            for (SpringBeanPointer bean : beans) {
                CommonSpringBean springBean = bean.getSpringBean();
                ThymeleafSpringBundleProvider.addPropertiesFile(propertiesFiles, module, bean.getContainingFile(), SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)springBean, (String)"basename"));
                for (String bundleName : SpringPropertyUtils.getArrayPropertyStringValues((CommonSpringBean)springBean, (String)"basenames")) {
                    ThymeleafSpringBundleProvider.addPropertiesFile(propertiesFiles, module, bean.getContainingFile(), bundleName);
                }
            }
            if (propertiesFiles.isEmpty()) {
                Collection<PropertiesFile> collection = ThymeleafSpringBundleProvider.getAllPropertiesFiles(module);
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getPropertiesFile"));
                }
                return collection;
            }
        }
        ArrayList arrayList = propertiesFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getPropertiesFile"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<PropertiesFile> getAllPropertiesFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getAllPropertiesFiles"));
        }
        final HashSet files = ContainerUtil.newHashSet();
        PropertiesReferenceManager.getInstance((Project)module.getProject()).processPropertiesFiles(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), new PropertiesFileProcessor(){

            public boolean process(String baseName, PropertiesFile propertiesFile) {
                files.add(propertiesFile);
                return true;
            }
        }, BundleNameEvaluator.DEFAULT);
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getAllPropertiesFiles"));
        }
        return hashSet;
    }

    private static List<SpringBeanPointer> getBundleMessageSourceBeans(Module module, SpringModel model) {
        ArrayList<SpringBeanPointer> beans = new ArrayList<SpringBeanPointer>();
        ThymeleafSpringBundleProvider.addAllBeansOfType(beans, module, model, "org.springframework.context.support.ResourceBundleMessageSource");
        ThymeleafSpringBundleProvider.addAllBeansOfType(beans, module, model, "org.springframework.context.support.ReloadableResourceBundleMessageSource");
        return beans;
    }

    private static void addAllBeansOfType(List<SpringBeanPointer> result, Module module, SpringModel model, String fqn) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(fqn, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false));
        if (psiClass == null) {
            return;
        }
        result.addAll(SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)psiClass)));
    }

    public static void addPropertiesFile(@NotNull List<PropertiesFile> propertiesFiles, @NotNull Module module, @NotNull PsiFile contextFile, @Nullable String basename) {
        if (propertiesFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesFiles", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "addPropertiesFile"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "addPropertiesFile"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "addPropertiesFile"));
        }
        if (StringUtil.isNotEmpty((String)basename)) {
            String bundleName = basename.replace('/', '.');
            PropertiesFile file = PropertiesReferenceManager.getInstance((Project)module.getProject()).findPropertiesFile(module, bundleName, null);
            if (file != null) {
                propertiesFiles.add(file);
            } else {
                Set<PropertiesFile> files = ThymeleafSpringBundleProvider.resourceManagerResolve(module, contextFile, basename + ".properties");
                if (files.size() > 0) {
                    propertiesFiles.addAll(files);
                } else {
                    propertiesFiles.addAll(ThymeleafSpringBundleProvider.resourceManagerResolve(module, contextFile, basename + ".xml"));
                }
            }
        }
    }

    @NotNull
    private static Set<PropertiesFile> resourceManagerResolve(@NotNull Module module, @NotNull PsiFile contextFile, @NotNull String basename) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "resourceManagerResolve"));
        }
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "resourceManagerResolve"));
        }
        if (basename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basename", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "resourceManagerResolve"));
        }
        HashSet files = ContainerUtil.newHashSet();
        try {
            SpringResourcesBuilder resourcesBuilder = SpringResourcesBuilder.create((PsiElement)ThymeleafSpringBundleProvider.getFakeElement(contextFile, basename), (String)basename, (int)0).fromRoot(basename.startsWith("/")).soft(false);
            PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(resourcesBuilder);
            for (int i = references.length - 1; i >= 0; --i) {
                ResolveResult[] results;
                PsiReference reference = references[i];
                if (!(reference instanceof FileReference)) continue;
                for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement resultElement = result.getElement();
                    if (!(resultElement instanceof PropertiesFile)) continue;
                    files.add((PropertiesFile)resultElement);
                }
                break;
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "resourceManagerResolve"));
        }
        return hashSet;
    }

    @NotNull
    private static RenameableFakePsiElement getFakeElement(@NotNull PsiFile contextFile, final @NotNull String basename) {
        if (contextFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextFile", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getFakeElement"));
        }
        if (basename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basename", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getFakeElement"));
        }
        RenameableFakePsiElement renameableFakePsiElement = new RenameableFakePsiElement((PsiElement)contextFile){

            public String getTypeName() {
                return null;
            }

            @Nullable
            public Icon getIcon() {
                return null;
            }

            public String getName() {
                return basename;
            }

            @Nullable
            public String getText() {
                return basename;
            }
        };
        if (renameableFakePsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/support/messages/spring/ThymeleafSpringBundleProvider", "getFakeElement"));
        }
        return renameableFakePsiElement;
    }
}

