/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThymeleafContextInitVariablesProvider
extends ThymeleafContextVariablesProvider {
    public static final String SET_VARIABLE_METHOD_NAME = "setVariable";

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider", "getContextVariables"));
        }
        Collection variables = (Collection)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> {
            if (contextElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider", "lambda$getContextVariables$0"));
            }
            return ThymeleafContextInitVariablesProvider.doCalculateInitVariables(contextElement);
        });
        Collection<Object> collection = variables == null ? Collections.emptySet() : variables;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider", "getContextVariables"));
        }
        return collection;
    }

    @NotNull
    private static Collection<? extends PsiVariable> doCalculateInitVariables(@NotNull PsiElement contextElement) {
        PsiMethod[] setVariableMethods;
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider", "doCalculateInitVariables"));
        }
        Project project = contextElement.getProject();
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass("org.thymeleaf.context.AbstractContext", GlobalSearchScope.allScope((Project)project));
        if (aClass != null && (setVariableMethods = aClass.findMethodsByName(SET_VARIABLE_METHOD_NAME, false)).length == 1) {
            Collection<ThymeleafVariable> collection = ThymeleafCommonUtil.getInitVariables(setVariableMethods[0]).values();
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider", "doCalculateInitVariables"));
            }
            return collection;
        }
        Set set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafContextInitVariablesProvider", "doCalculateInitVariables"));
        }
        return set;
    }
}

