/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud.deploymentSource;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.cloud.OS3Util;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3LocalTemplateDeploymentSourceType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OS3LocalTemplateDeploymentSource
implements DeploymentSource {
    private final File myFile;
    private final Project myProject;

    public OS3LocalTemplateDeploymentSource(Project project, File templateFile) {
        this.myProject = project;
        this.myFile = templateFile.isAbsolute() ? templateFile : new File(project.getBasePath(), templateFile.getPath());
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/deploymentSource/OS3LocalTemplateDeploymentSource", "getFile"));
        }
        return file;
    }

    @NotNull
    public String getFilePath() {
        String string = this.myFile.getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/deploymentSource/OS3LocalTemplateDeploymentSource", "getFilePath"));
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = OS3Util.getRelativeToProjectPath(this.myProject, this.myFile);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/deploymentSource/OS3LocalTemplateDeploymentSource", "getPresentableName"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isArchive() {
        return false;
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        DeploymentSourceType deploymentSourceType = (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(OS3LocalTemplateDeploymentSourceType.class);
        if (deploymentSourceType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/deploymentSource/OS3LocalTemplateDeploymentSource", "getType"));
        }
        return deploymentSourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OS3LocalTemplateDeploymentSource)) {
            return false;
        }
        return FileUtil.filesEqual((File)this.myFile, (File)((OS3LocalTemplateDeploymentSource)o).myFile);
    }
}

