/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.css.CssIdSelector;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCSSReferenceContributor;
import org.jetbrains.plugins.javaFX.css.rename.JavaFxCssRefactoringsSettings;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxCssIdAutomaticRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        String qualifiedName;
        PsiField field;
        PsiClass containingClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/css/rename/JavaFxCssIdAutomaticRenamerFactory", "isApplicable"));
        }
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            return !JavaFxControllerClassIndex.findFxmlWithController(containingClass.getProject(), qualifiedName).isEmpty();
        }
        return false;
    }

    @Nullable
    public String getOptionName() {
        return "Rename id selector in css";
    }

    public boolean isEnabled() {
        return JavaFxCssRefactoringsSettings.getInstance().RENAME_ID_SELECTOR;
    }

    public void setEnabled(boolean enabled) {
        JavaFxCssRefactoringsSettings.getInstance().RENAME_ID_SELECTOR = enabled;
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        if (element instanceof XmlAttributeValue) {
            JavaFxCssIdAutomaticRenamer javaFxCssIdAutomaticRenamer = new JavaFxCssIdAutomaticRenamer((XmlAttributeValue)element, newName);
            if (javaFxCssIdAutomaticRenamer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/rename/JavaFxCssIdAutomaticRenamerFactory", "createRenamer"));
            }
            return javaFxCssIdAutomaticRenamer;
        }
        JavaFxCssIdAutomaticRenamer javaFxCssIdAutomaticRenamer = new JavaFxCssIdAutomaticRenamer((PsiField)element, newName);
        if (javaFxCssIdAutomaticRenamer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/css/rename/JavaFxCssIdAutomaticRenamerFactory", "createRenamer"));
        }
        return javaFxCssIdAutomaticRenamer;
    }

    private static class JavaFxCssIdAutomaticRenamer
    extends AutomaticRenamer {
        private static final Logger LOG = Logger.getInstance(JavaFxCssIdAutomaticRenamer.class);

        public JavaFxCssIdAutomaticRenamer(PsiField field, String newName) {
            String fieldName = field.getName();
            PsiClass containingClass = field.getContainingClass();
            LOG.assertTrue(containingClass != null);
            String qualifiedName = containingClass.getQualifiedName();
            LOG.assertTrue(qualifiedName != null);
            this.collectAllNames((PsiElement)field, newName, fieldName);
        }

        public JavaFxCssIdAutomaticRenamer(XmlAttributeValue element, String newName) {
            this.collectAllNames((PsiElement)element, newName, element.getValue());
        }

        private void collectAllNames(PsiElement element, String newName, String oldName) {
            Collection<VirtualFile> cssFiles;
            if (!StringUtil.isEmpty((String)oldName) && !(cssFiles = JavaFxCSSReferenceContributor.getMyCss(element)).isEmpty()) {
                Project project = element.getProject();
                CssIndexUtil.processIds((String)oldName, (Project)project, (GlobalSearchScope)GlobalSearchScope.filesScope((Project)project, cssFiles), (name, suffix) -> {
                    if (suffix instanceof CssIdSelector) {
                        this.myElements.add(suffix);
                    }
                    return true;
                });
            }
            this.suggestAllNames(oldName, newName);
        }

        public String getDialogTitle() {
            return "Rename JavaFX CSS Id Selectors";
        }

        public String getDialogDescription() {
            return "Rename css id selectors with the following names to:";
        }

        public String entityName() {
            return "CSS id selector";
        }
    }
}

