/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.jboss.jbpm.dnd.ChartDnDNodeDefinition;
import com.intellij.jboss.jbpm.dnd.node.ChartDnDJointNode;
import com.intellij.jboss.jbpm.dnd.node.ChartDnDLeafNode;
import com.intellij.jboss.jbpm.dnd.node.ChartDnDNode;
import com.intellij.jboss.jbpm.layout.ChartLayoutCoordinator;
import com.intellij.jboss.jbpm.model.ChartDataModel;
import com.intellij.jboss.jbpm.model.ChartNode;
import com.intellij.jboss.jbpm.render.size.ChartNodeSizeEnhancer;
import com.intellij.jboss.jbpm.render.size.RenderDefaultSize;
import com.intellij.jboss.jbpm.ui.ChartBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.dnd.DraggedComponentsTree;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDPanel;
import com.intellij.openapi.graph.builder.dnd.SimpleGraphDnDStructure;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Function;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChartDnDSupport<T, Model extends ChartDataModel<T>, Node extends ChartNode<T>, NodeT extends Enum<NodeT>>
implements GraphDnDSupport<Node, NodeT> {
    @NotNull
    protected final Model model;
    @NotNull
    protected final ChartBuilder<T> builder;
    @NotNull
    private final NodeT[] values;
    private final boolean startInWCA;

    public ChartDnDSupport(@NotNull Model model, @NotNull ChartBuilder<T> builder, @NotNull NodeT[] values, boolean wca) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/jboss/jbpm/dnd/ChartDnDSupport", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/jboss/jbpm/dnd/ChartDnDSupport", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/jboss/jbpm/dnd/ChartDnDSupport", "<init>"));
        }
        this.model = model;
        this.builder = builder;
        this.values = values;
        this.startInWCA = wca;
    }

    public Map<NodeT, Pair<String, Icon>> getDnDActions() {
        LinkedHashMap<NodeT, Pair> nodes = new LinkedHashMap<NodeT, Pair>();
        for (NodeT nodeType : this.values) {
            nodes.put(nodeType, Pair.create((Object)((ChartDnDNodeDefinition)nodeType).getName(), (Object)((ChartDnDNodeDefinition)nodeType).getIcon()));
        }
        return nodes;
    }

    @Nullable
    public Node drop(NodeT t) {
        return null;
    }

    private void createNodeLayout(Node node, ChartLayoutCoordinator.Point point) {
        RenderDefaultSize size;
        ChartLayoutCoordinator.NodeLayout nodeLayout;
        ChartLayoutCoordinator chartLayoutCoordinator = this.builder.getChartLayoutCoordinator();
        if (chartLayoutCoordinator == null) {
            return;
        }
        String fqn = this.builder.getProvider().getVfsResolver().getQualifiedName(node.getIdentifyingElement());
        Runnable createLayoutAction = chartLayoutCoordinator.getChangeNodeLayoutAction(fqn, nodeLayout = ChartLayoutCoordinator.NodeLayout.createByCenterPoint(new ChartLayoutCoordinator.Size((size = this.builder.getProvider().getExtras().getRenderSizeCoordinator().getAnnotation(((ChartNode)((Object)node)).getClassesWithAnnotationsForRendering())).width(), size.height()), point), ChartNodeSizeEnhancer.enhancerForNode(node));
        if (createLayoutAction != null) {
            createLayoutAction.run();
        }
    }

    @Nullable
    public Node drop(NodeT nodeType, ChartLayoutCoordinator.Point point) {
        final Function fn = t -> {
            Function createFunction = ((ChartDnDNodeDefinition)((Object)nodeType)).getCreateFunction();
            if (createFunction == null) {
                return null;
            }
            ChartNode node = (ChartNode)((Object)((Object)createFunction.fun(this.model)));
            this.createNodeLayout(node, point);
            return node;
        };
        if (!this.startInWCA) {
            return (Node)((Object)((ChartNode)((Object)fn.fun(nodeType))));
        }
        VirtualFile virtualFile = this.builder.getEditorFile();
        PsiFile file = virtualFile == null ? null : PsiManager.getInstance((Project)this.builder.getProject()).findFile(virtualFile);
        return (Node)((Object)((ChartNode)((Object)new WriteCommandAction<Node>(this.builder.getProject(), "Add " + this.builder.getProvider().getChartName() + " node", new PsiFile[]{file}, (Enum)nodeType){
            final /* synthetic */ Enum val$nodeType;
            {
                this.val$nodeType = enum_;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Node> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jboss/jbpm/dnd/ChartDnDSupport$1", "run"));
                }
                result.setResult(fn.fun((Object)this.val$nodeType));
            }
        }.execute().getResultObject())));
    }

    public SimpleGraphDnDStructure createStructure(Project project) {
        ArrayList<ChartDnDNode> result;
        ArrayList<ChartDnDNode> nodesToAdd = result = new ArrayList<ChartDnDNode>();
        for (NodeT node : this.values) {
            if (!((ChartDnDNodeDefinition)node).isLeafNode()) {
                nodesToAdd = new ArrayList();
                result.add(new ChartDnDJointNode(project, ((ChartDnDNodeDefinition)node).getName(), ((ChartDnDNodeDefinition)node).getIcon(), nodesToAdd));
                continue;
            }
            nodesToAdd.add(new ChartDnDLeafNode<NodeT>(project, (Enum)node, ((ChartDnDNodeDefinition)node).getName(), ((ChartDnDNodeDefinition)node).getIcon()){

                @Override
                public boolean canStartDragging() {
                    return ChartDnDSupport.this.canStartDragging(this.getValue());
                }
            });
        }
        final ChartDnDNode[] nodes = result.toArray(new ChartDnDNode[result.size()]);
        return new SimpleGraphDnDStructure(project){

            protected SimpleNode[] getChildren(Project project) {
                return nodes;
            }
        };
    }

    public SimpleDnDPanel createDnDActions(Project project, ChartBuilder builder) {
        SimpleGraphDnDStructure graphDnDStructure = this.createStructure(project);
        SimpleDnDPanel simpleDnDPanel = new SimpleDnDPanel(graphDnDStructure);
        DnDManager dndManager = DnDManager.getInstance();
        dndManager.registerSource((DnDSource)new ChartDnDSource(simpleDnDPanel.getTree()), (JComponent)simpleDnDPanel.getTree());
        dndManager.registerTarget((DnDTarget)new ChartDnDTarget(builder), builder.getView().getJComponent());
        Disposer.register((Disposable)builder, (Disposable)simpleDnDPanel.getBuilder());
        return simpleDnDPanel;
    }

    private class ChartDnDTarget
    implements DnDTarget {
        private final ChartBuilder builder;

        private ChartDnDTarget(ChartBuilder builder) {
            this.builder = builder;
        }

        public boolean update(DnDEvent aEvent) {
            aEvent.setDropPossible(true);
            return false;
        }

        public void drop(DnDEvent aEvent) {
            Object attachedObject = aEvent.getAttachedObject();
            assert (attachedObject instanceof Enum);
            assert (attachedObject instanceof ChartDnDNodeDefinition);
            Enum attachedNodeT = (Enum)attachedObject;
            Point point = aEvent.getPoint();
            Object chartNode = ChartDnDSupport.this.drop(attachedNodeT, new ChartLayoutCoordinator.Point(point.getX(), point.getY()));
            if (chartNode != null) {
                String nodeName = this.builder.getGraphDataModel().getNodeName(chartNode);
                NodeFactory.getInstance().createDraggedNode((GraphBuilder)this.builder, chartNode, nodeName, point);
            }
        }

        public void cleanUpOnLeave() {
        }

        public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
        }
    }

    private static class ChartDnDSource
    implements DnDSource {
        private final DraggedComponentsTree myTree;

        public ChartDnDSource(DraggedComponentsTree tree) {
            this.myTree = tree;
        }

        public boolean canStartDragging(DnDAction action, Point dragOrigin) {
            SimpleNode node = this.myTree.getSelectedNode();
            if (node == null || !(node instanceof ChartDnDLeafNode)) {
                return false;
            }
            return ((ChartDnDLeafNode)node).canStartDragging();
        }

        public DnDDragStartBean startDragging(DnDAction action, Point point) {
            SimpleNode node = this.myTree.getSelectedNode();
            if (node == null || !(node instanceof ChartDnDLeafNode)) {
                return null;
            }
            return new DnDDragStartBean(((ChartDnDLeafNode)this.myTree.getSelectedNode()).getValue());
        }

        @Nullable
        public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
            return null;
        }

        public void dragDropEnd() {
        }

        public void dropActionChanged(int gestureModifiers) {
        }
    }
}

