/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.SdkConstants;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.klint.client.api.CircularDependencyException;
import com.android.tools.klint.client.api.ClassEntry;
import com.android.tools.klint.client.api.CompositeIssueRegistry;
import com.android.tools.klint.client.api.Configuration;
import com.android.tools.klint.client.api.DefaultConfiguration;
import com.android.tools.klint.client.api.DefaultSdkInfo;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.JarFileIssueRegistry;
import com.android.tools.klint.client.api.JavaParser;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.client.api.SdkInfo;
import com.android.tools.klint.client.api.XmlParser;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Beta
public abstract class LintClient {
    private static final String PROP_BIN_DIR = "com.android.tools.lint.bindir";
    private Map<Project, ClassPathInfo> mProjectInfo;
    protected Map<File, Project> mDirToProject;
    protected Set<File> mProjectDirs = Sets.newHashSet();
    protected IAndroidTarget[] mTargets;
    protected AndroidSdkHandler mSdk;
    private ResourceVisibilityLookup.Provider mResourceVisibility;
    public static final String CLIENT_STUDIO = "studio";
    public static final String CLIENT_GRADLE = "gradle";
    public static final String CLIENT_CLI = "cli";
    public static final String CLIENT_UNKNOWN = "unknown";
    private static String sClientName = "unknown";

    protected LintClient(String clientName) {
        sClientName = clientName;
    }

    protected LintClient() {
        sClientName = CLIENT_UNKNOWN;
    }

    public Configuration getConfiguration(Project project, LintDriver driver) {
        return DefaultConfiguration.create(this, project, null);
    }

    public abstract void report(Context var1, Issue var2, Severity var3, Location var4, String var5, TextFormat var6);

    public void log(Throwable exception, String format, Object ... args) {
        this.log(Severity.WARNING, exception, format, args);
    }

    public abstract void log(Severity var1, Throwable var2, String var3, Object ... var4);

    public abstract XmlParser getXmlParser();

    public abstract JavaParser getJavaParser(Project var1);

    public Class<? extends Detector> replaceDetector(Class<? extends Detector> detectorClass) {
        return detectorClass;
    }

    public abstract String readFile(File var1);

    public byte[] readBytes(File file) throws IOException {
        return Files.toByteArray((File)file);
    }

    public List<File> getJavaSourceFolders(Project project) {
        return this.getClassPath(project).getSourceFolders();
    }

    public List<File> getJavaClassFolders(Project project) {
        return this.getClassPath(project).getClassFolders();
    }

    public List<File> getJavaLibraries(Project project, boolean includeProvided) {
        return this.getClassPath(project).getLibraries(includeProvided);
    }

    public List<File> getTestSourceFolders(Project project) {
        return this.getClassPath(project).getTestSourceFolders();
    }

    public List<File> getResourceFolders(Project project) {
        File res = new File(project.getDir(), "res");
        if (res.exists()) {
            return Collections.singletonList(res);
        }
        return Collections.emptyList();
    }

    public List<File> getAssetFolders(Project project) {
        File assets = new File(project.getDir(), "assets");
        if (assets.exists()) {
            return Collections.singletonList(assets);
        }
        return Collections.emptyList();
    }

    public SdkInfo getSdkInfo(Project project) {
        return new DefaultSdkInfo();
    }

    public File getCacheDir(boolean create) {
        String home = System.getProperty("user.home");
        String relative = ".android" + File.separator + "cache";
        File dir = new File(home, relative);
        if (create && !dir.exists() && !dir.mkdirs()) {
            return null;
        }
        return dir;
    }

    private static File getLintBinDir() {
        File file;
        String path = System.getProperty(PROP_BIN_DIR);
        if (path == null || path.isEmpty()) {
            path = System.getenv(PROP_BIN_DIR);
        }
        if (path != null && !path.isEmpty() && (file = new File(path)).exists()) {
            return file;
        }
        return null;
    }

    public File getSdkHome() {
        String home;
        File binDir = LintClient.getLintBinDir();
        if (binDir != null) {
            assert (binDir.getName().equals("tools"));
            File root = binDir.getParentFile();
            if (root != null && root.isDirectory()) {
                return root;
            }
        }
        if ((home = System.getenv("ANDROID_HOME")) != null) {
            return new File(home);
        }
        return null;
    }

    public File findResource(String relativePath) {
        File top = this.getSdkHome();
        if (top == null) {
            throw new IllegalArgumentException("Lint must be invoked with the System property com.android.tools.lint.bindir pointing to the ANDROID_SDK tools directory");
        }
        File file = new File(top, relativePath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean isGradleProject(Project project) {
        File root;
        if (new File(project.getDir(), "build.gradle").exists()) {
            return true;
        }
        File parent = project.getDir().getParentFile();
        return parent != null && parent.getName().equals("src") && (root = parent.getParentFile()) != null && new File(root, "build.gradle").exists();
    }

    protected ClassPathInfo getClassPath(Project project) {
        ClassPathInfo info;
        if (this.mProjectInfo == null) {
            this.mProjectInfo = Maps.newHashMap();
            info = null;
        } else {
            info = this.mProjectInfo.get(project);
        }
        if (info == null) {
            File[] jars;
            File libs;
            ArrayList<File> sources = new ArrayList<File>(2);
            ArrayList<File> classes2 = new ArrayList<File>(1);
            ArrayList<File> libraries = new ArrayList<File>();
            List<File> tests = Collections.emptyList();
            File projectDir = project.getDir();
            File classpathFile = new File(projectDir, ".classpath");
            if (classpathFile.exists()) {
                String classpathXml = this.readFile(classpathFile);
                try {
                    Document document = XmlUtils.parseDocument((String)classpathXml, (boolean)false);
                    File[] tags = document.getElementsByTagName("classpathentry");
                    int n = tags.getLength();
                    for (int i = 0; i < n; ++i) {
                        String path;
                        File folder;
                        Element element = (Element)tags.item(i);
                        String kind2 = element.getAttribute("kind");
                        ArrayList<File> addTo = null;
                        if (kind2.equals("src")) {
                            addTo = sources;
                        } else if (kind2.equals("output")) {
                            addTo = classes2;
                        } else if (kind2.equals("lib")) {
                            addTo = libraries;
                        }
                        if (addTo == null || !(folder = new File(projectDir, path = element.getAttribute("path"))).exists()) continue;
                        addTo.add(folder);
                    }
                }
                catch (Exception e) {
                    this.log(null, null, new Object[0]);
                }
            }
            if ((libs = new File(project.getDir(), "libs")).isDirectory() && (jars = libs.listFiles()) != null) {
                for (File jar : jars) {
                    if (!LintUtils.endsWith(jar.getPath(), ".jar") || libraries.contains(jar)) continue;
                    libraries.add(jar);
                }
            }
            if (classes2.isEmpty()) {
                File folder = new File(projectDir, SdkConstants.CLASS_FOLDER);
                if (folder.exists()) {
                    classes2.add(folder);
                } else {
                    folder = new File(projectDir, "target" + File.separator + "classes");
                    if (folder.exists()) {
                        classes2.add(folder);
                        if (sources.isEmpty()) {
                            File src = new File(projectDir, "src" + File.separator + "main" + File.separator + "java");
                            if (src.exists()) {
                                sources.add(src);
                            } else {
                                src = new File(projectDir, "src");
                                if (src.exists()) {
                                    sources.add(src);
                                }
                            }
                            File gen = new File(projectDir, "target" + File.separator + "generated-sources" + File.separator + "r");
                            if (gen.exists()) {
                                sources.add(gen);
                            }
                        }
                    }
                }
            }
            if (sources.isEmpty()) {
                File gen;
                File src = new File(projectDir, "src");
                if (src.exists()) {
                    sources.add(src);
                }
                if ((gen = new File(projectDir, "gen")).exists()) {
                    sources.add(gen);
                }
            }
            info = new ClassPathInfo(sources, classes2, libraries, libraries, tests);
            this.mProjectInfo.put(project, info);
        }
        return info;
    }

    public Project getProject(File dir, File referenceDir) {
        if (this.mDirToProject == null) {
            this.mDirToProject = new HashMap<File, Project>();
        }
        File canonicalDir = dir;
        try {
            canonicalDir = dir.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Project project = this.mDirToProject.get(canonicalDir);
        if (project != null) {
            return project;
        }
        project = this.createProject(dir, referenceDir);
        this.mDirToProject.put(canonicalDir, project);
        return project;
    }

    public Collection<Project> getKnownProjects() {
        return this.mDirToProject != null ? this.mDirToProject.values() : Collections.emptyList();
    }

    public void registerProject(File dir, Project project) {
        File canonicalDir = dir;
        try {
            canonicalDir = dir.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.mDirToProject == null) {
            this.mDirToProject = new HashMap<File, Project>();
        } else assert (!this.mDirToProject.containsKey(dir)) : dir;
        this.mDirToProject.put(canonicalDir, project);
    }

    protected Project createProject(File dir, File referenceDir) {
        if (this.mProjectDirs.contains(dir)) {
            throw new CircularDependencyException("Circular library dependencies; check your project.properties files carefully");
        }
        this.mProjectDirs.add(dir);
        return Project.create(this, dir, referenceDir);
    }

    public String getProjectName(Project project) {
        return project.getDir().getName();
    }

    public IAndroidTarget[] getTargets() {
        if (this.mTargets == null) {
            AndroidSdkHandler sdkHandler = this.getSdk();
            if (sdkHandler != null) {
                ProgressIndicator logger = this.getRepositoryLogger();
                Collection targets = sdkHandler.getAndroidTargetManager(logger).getTargets(logger);
                this.mTargets = targets.toArray(new IAndroidTarget[targets.size()]);
            } else {
                this.mTargets = new IAndroidTarget[0];
            }
        }
        return this.mTargets;
    }

    public AndroidSdkHandler getSdk() {
        File sdkHome;
        if (this.mSdk == null && (sdkHome = this.getSdkHome()) != null) {
            this.mSdk = AndroidSdkHandler.getInstance((File)sdkHome);
        }
        return this.mSdk;
    }

    public IAndroidTarget getCompileTarget(Project project) {
        int buildSdk = project.getBuildSdk();
        IAndroidTarget[] targets = this.getTargets();
        for (int i = targets.length - 1; i >= 0; --i) {
            IAndroidTarget target = targets[i];
            if (!target.isPlatform() || target.getVersion().getApiLevel() != buildSdk) continue;
            return target;
        }
        return null;
    }

    public int getHighestKnownApiLevel() {
        int max = 25;
        for (IAndroidTarget target : this.getTargets()) {
            int api;
            if (!target.isPlatform() || (api = target.getVersion().getApiLevel()) <= max || target.getVersion().isPreview()) continue;
            max = api;
        }
        return max;
    }

    public BuildToolInfo getBuildTools(Project project) {
        return null;
    }

    public String getSuperClass(Project project, String name) {
        assert (name.indexOf(46) == -1) : "Use VM signatures, e.g. java/lang/Integer";
        if ("java/lang/Object".equals(name)) {
            return null;
        }
        String superClass = project.getSuperClassMap().get(name);
        if (superClass != null) {
            return superClass;
        }
        for (Project library : project.getAllLibraries()) {
            superClass = library.getSuperClassMap().get(name);
            if (superClass == null) continue;
            return superClass;
        }
        return null;
    }

    public Map<String, String> createSuperClassMap(Project project) {
        List<File> libraries = project.getJavaLibraries(true);
        List<File> classFolders = project.getJavaClassFolders();
        List<ClassEntry> classEntries = ClassEntry.fromClassPath(this, classFolders, true);
        if (libraries.isEmpty()) {
            return ClassEntry.createSuperClassMap(this, classEntries);
        }
        List<ClassEntry> libraryEntries = ClassEntry.fromClassPath(this, libraries, true);
        return ClassEntry.createSuperClassMap(this, libraryEntries, classEntries);
    }

    public Boolean isSubclassOf(Project project, String name, String superClassName) {
        return null;
    }

    public List<File> findGlobalRuleJars() {
        String lintClassPath;
        File jarFile;
        List<File> files = null;
        try {
            File[] list;
            String androidHome = AndroidLocation.getFolder();
            File lint = new File(androidHome + File.separator + "lint");
            if (lint.exists() && (list = lint.listFiles()) != null) {
                File[] fileArray = list;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    jarFile = fileArray[i];
                    if (!LintUtils.endsWith(jarFile.getName(), ".jar")) continue;
                    if (files == null) {
                        files = new ArrayList<File>();
                    }
                    files.add(jarFile);
                }
            }
        }
        catch (AndroidLocation.AndroidLocationException androidHome) {
            // empty catch block
        }
        if ((lintClassPath = System.getenv("ANDROID_LINT_JARS")) != null && !lintClassPath.isEmpty()) {
            String[] paths;
            for (String path : paths = lintClassPath.split(File.pathSeparator)) {
                jarFile = new File(path);
                if (!jarFile.exists()) continue;
                if (files == null) {
                    files = new ArrayList<File>();
                } else if (files.contains(jarFile)) continue;
                files.add(jarFile);
            }
        }
        return files != null ? files : Collections.emptyList();
    }

    public List<File> findRuleJars(Project project) {
        if (project.isGradleProject()) {
            File lintJar;
            if (project.isLibrary()) {
                File lintJar2;
                AndroidLibrary model = project.getGradleLibraryModel();
                if (model != null && (lintJar2 = model.getLintJar()).exists()) {
                    return Collections.singletonList(lintJar2);
                }
            } else if (project.getSubset() != null) {
                ArrayList rules = null;
                Variant variant = project.getCurrentVariant();
                if (variant != null) {
                    Collection libraries = variant.getMainArtifact().getDependencies().getLibraries();
                    for (AndroidLibrary library : libraries) {
                        File lintJar3 = library.getLintJar();
                        if (!lintJar3.exists()) continue;
                        if (rules == null) {
                            rules = Lists.newArrayListWithExpectedSize((int)4);
                        }
                        rules.add(lintJar3);
                    }
                    if (rules != null) {
                        return rules;
                    }
                }
            } else if (project.getDir().getPath().endsWith(".aar") && (lintJar = new File(project.getDir(), "lint.jar")).exists()) {
                return Collections.singletonList(lintJar);
            }
        }
        return Collections.emptyList();
    }

    public URLConnection openConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public void closeConnection(URLConnection connection) throws IOException {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    public boolean isProjectDirectory(File dir) {
        return LintUtils.isManifestFolder(dir) || Project.isAospFrameworksRelatedProject(dir);
    }

    public boolean checkForSuppressComments() {
        return true;
    }

    public IssueRegistry addCustomLintRules(IssueRegistry registry) {
        List<File> jarFiles = this.findGlobalRuleJars();
        if (!jarFiles.isEmpty()) {
            ArrayList registries = Lists.newArrayListWithExpectedSize((int)jarFiles.size());
            registries.add(registry);
            for (File jarFile : jarFiles) {
                try {
                    registries.add(JarFileIssueRegistry.get(this, jarFile));
                }
                catch (Throwable e) {
                    this.log(e, "Could not load custom rule jar file %1$s", jarFile);
                }
            }
            if (registries.size() > 1) {
                return new CompositeIssueRegistry(registries);
            }
        }
        return registry;
    }

    public ClassLoader createUrlClassLoader(URL[] urls, ClassLoader parent) {
        return new URLClassLoader(urls, parent);
    }

    public boolean supportsProjectResources() {
        return false;
    }

    public AbstractResourceRepository getProjectResources(Project project, boolean includeDependencies) {
        return null;
    }

    public Location.Handle createResourceItemHandle(ResourceItem item) {
        return new Location.ResourceItemHandle(item);
    }

    public ResourceVisibilityLookup.Provider getResourceVisibilityProvider() {
        if (this.mResourceVisibility == null) {
            this.mResourceVisibility = new ResourceVisibilityLookup.Provider();
        }
        return this.mResourceVisibility;
    }

    public static String getClientName() {
        return sClientName;
    }

    public static boolean isStudio() {
        return CLIENT_STUDIO.equals(sClientName);
    }

    public static boolean isGradle() {
        return CLIENT_GRADLE.equals(sClientName);
    }

    public ProgressIndicator getRepositoryLogger() {
        return new RepoLogger();
    }

    private static final class RepoLogger
    extends ProgressIndicatorAdapter {
        private RepoLogger() {
        }

        public void logError(String s, Throwable e) {
        }

        public void logInfo(String s) {
        }

        public void logWarning(String s, Throwable e) {
        }
    }

    protected static class ClassPathInfo {
        private final List<File> mClassFolders;
        private final List<File> mSourceFolders;
        private final List<File> mLibraries;
        private final List<File> mNonProvidedLibraries;
        private final List<File> mTestFolders;

        public ClassPathInfo(List<File> sourceFolders, List<File> classFolders, List<File> libraries, List<File> nonProvidedLibraries, List<File> testFolders) {
            this.mSourceFolders = sourceFolders;
            this.mClassFolders = classFolders;
            this.mLibraries = libraries;
            this.mNonProvidedLibraries = nonProvidedLibraries;
            this.mTestFolders = testFolders;
        }

        public List<File> getSourceFolders() {
            return this.mSourceFolders;
        }

        public List<File> getClassFolders() {
            return this.mClassFolders;
        }

        public List<File> getLibraries(boolean includeProvided) {
            return includeProvided ? this.mLibraries : this.mNonProvidedLibraries;
        }

        public List<File> getTestSourceFolders() {
            return this.mTestFolders;
        }
    }
}

