/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data.javaee;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.task.ArtifactBuildTask;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.build.GradleArtifactBuildTasksProvider;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactProperties;
import org.jetbrains.plugins.gradle.service.project.data.javaee.GradleArtifactPropertiesProvider;

public class JeeArtifactBuildTasksProvider
implements GradleArtifactBuildTasksProvider {
    public boolean isApplicable(@NotNull ArtifactBuildTask artifactBuildTask) {
        if (artifactBuildTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactBuildTask", "org/jetbrains/plugins/gradle/service/project/data/javaee/JeeArtifactBuildTasksProvider", "isApplicable"));
        }
        ArtifactProperties artifactProperties = artifactBuildTask.getArtifact().getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance());
        if (artifactProperties == null || !(artifactProperties.getState() instanceof GradleArtifactProperties)) {
            return false;
        }
        return StringUtil.isNotEmpty((String)((GradleArtifactProperties)((Object)artifactProperties.getState())).getExternalProjectPath());
    }

    public void addArtifactsTargetsBuildTasks(@NotNull ArtifactBuildTask artifactBuildTask, @NotNull Consumer<ExternalTaskPojo> cleanTasksConsumer, @NotNull Consumer<ExternalTaskPojo> buildTasksConsumer) {
        if (artifactBuildTask == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactBuildTask", "org/jetbrains/plugins/gradle/service/project/data/javaee/JeeArtifactBuildTasksProvider", "addArtifactsTargetsBuildTasks"));
        }
        if (cleanTasksConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cleanTasksConsumer", "org/jetbrains/plugins/gradle/service/project/data/javaee/JeeArtifactBuildTasksProvider", "addArtifactsTargetsBuildTasks"));
        }
        if (buildTasksConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildTasksConsumer", "org/jetbrains/plugins/gradle/service/project/data/javaee/JeeArtifactBuildTasksProvider", "addArtifactsTargetsBuildTasks"));
        }
        Artifact artifact = artifactBuildTask.getArtifact();
        Object state = artifact.getProperties((ArtifactPropertiesProvider)GradleArtifactPropertiesProvider.getInstance()).getState();
        if (state instanceof GradleArtifactProperties) {
            String projectPath = ((GradleArtifactProperties)((Object)state)).getExternalProjectPath();
            if (WebArtifactUtil.getInstance().isWebApplication(artifact.getArtifactType())) {
                if (!artifactBuildTask.isIncrementalBuild()) {
                    cleanTasksConsumer.consume((Object)new ExternalTaskPojo("cleanWar", projectPath, null));
                }
                buildTasksConsumer.consume((Object)new ExternalTaskPojo("war", projectPath, null));
            } else if (JavaeeArtifactUtil.getInstance().isJavaeeApplication(artifact.getArtifactType())) {
                if (!artifactBuildTask.isIncrementalBuild()) {
                    cleanTasksConsumer.consume((Object)new ExternalTaskPojo("cleanEar", projectPath, null));
                }
                buildTasksConsumer.consume((Object)new ExternalTaskPojo("ear", projectPath, null));
            }
        }
    }
}

