/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class SpringInitializrFormBuilder
extends FormBuilder {
    SpringInitializrFormBuilder() {
        this.setFormLeftIndent(10);
    }

    ComboBox addComboBox(String label, CollectionComboBoxModel<SpringInitializrOptions.Option> model) {
        final ComboBox comboBox = new ComboBox(model);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<SpringInitializrOptions.Option>(){

            protected void customizeCellRenderer(@NotNull JList list, SpringInitializrOptions.Option option, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/spring/initializr/SpringInitializrFormBuilder$1", "customizeCellRenderer"));
                }
                this.append(option.display);
                String description = option.description;
                if (StringUtil.isNotEmpty((String)description)) {
                    this.append(" (" + description + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
                SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)comboBox, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
            }
        });
        new ComboboxSpeedSearch((JComboBox)comboBox){

            protected String getElementText(Object element) {
                SpringInitializrOptions.Option option = (SpringInitializrOptions.Option)((Object)element);
                return option.display;
            }
        };
        this.addLabeledComponent(label + ":", (JComponent)comboBox);
        return comboBox;
    }

    JBTextField addTextField(String label, String value) {
        JBTextField field = new JBTextField(value);
        field.setColumns(50);
        this.addLabeledComponent(label + ":", (JComponent)field);
        return field;
    }

    void addVerticalSpacing() {
        this.addVerticalGap(4);
    }
}

