/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringInitializrRunConfigUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.initializr.SpringInitializrRunConfigUtil");
    private final Module myModule;
    private final RunManager myRunManager;
    private final SpringBootApplicationConfigurationTypeBase mySpringBootType;

    public SpringInitializrRunConfigUtil(Module module) {
        this.myModule = module;
        this.myRunManager = RunManager.getInstance((Project)this.myModule.getProject());
        this.mySpringBootType = SpringBootApplicationConfigurationTypeBase.getInstance();
    }

    public void createRunConfig() {
        SpringBootSettings configuration = SpringBootSettings.getInstance((Project)this.myModule.getProject());
        if (!configuration.isAutoCreateRunConfiguration()) {
            return;
        }
        DumbService.getInstance((Project)this.myModule.getProject()).runReadActionInSmartMode(this::createSpringBootRunConfiguration);
    }

    private void createSpringBootRunConfiguration() {
        List applications = SpringBootApplicationUtil.getSpringApplications((Module)this.myModule);
        if (applications.size() != 1) {
            return;
        }
        PsiClass springBootApp = (PsiClass)applications.get(0);
        if (this.hasSpringBootRunConfiguration(springBootApp)) {
            return;
        }
        this.createSpringBootRunConfiguration(springBootApp);
    }

    private void createSpringBootRunConfiguration(PsiClass springBootApp) {
        try {
            RunnerAndConfigurationSettings settings = this.myRunManager.createRunConfiguration("", this.mySpringBootType.getDefaultConfigurationFactory());
            SpringBootApplicationRunConfigurationBase newRunConfig = (SpringBootApplicationRunConfigurationBase)settings.getConfiguration();
            newRunConfig.setModule(this.myModule);
            newRunConfig.setSpringBootMainClass(springBootApp.getQualifiedName());
            settings.setName(newRunConfig.suggestedName());
            this.myRunManager.addConfiguration(settings, false);
            if (this.myRunManager.getAllSettings().size() == 1) {
                this.myRunManager.setSelectedConfiguration(settings);
            }
        }
        catch (Throwable t) {
            LOG.error("Error creating Spring Boot run configuration for " + springBootApp, t);
        }
    }

    private boolean hasSpringBootRunConfiguration(@NotNull PsiClass applicationClass) {
        if (applicationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationClass", "com/intellij/spring/initializr/SpringInitializrRunConfigUtil", "hasSpringBootRunConfiguration"));
        }
        List allSpringBootRunConfigs = ContainerUtil.findAll((Collection)this.myRunManager.getConfigurationsList((ConfigurationType)this.mySpringBootType), SpringBootApplicationRunConfigurationBase.class);
        for (SpringBootApplicationRunConfigurationBase config : allSpringBootRunConfigs) {
            if (!config.getSpringBootMainClass().equals(applicationClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

