/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.ExpressionInfoFactory;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.JavaScriptNameMapper;
import com.intellij.javascript.debugger.JavaScriptNameMapperKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.scripts.ScriptsKt;
import com.intellij.javascript.debugger.sourcemap.SourceEntriesProcessor;
import com.intellij.javascript.debugger.sourcemap.SourceMapHelperKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PromiseDebuggerEvaluator;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.values.ObjectValue;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J4\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J8\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J0\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u0004\u0018\u00010\u001e2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006*"}, d2={"Lcom/intellij/javascript/debugger/ChromeEvaluator;", "Lorg/jetbrains/debugger/PromiseDebuggerEvaluator;", "Lcom/intellij/javascript/debugger/ExpressionInfoFactory;", "context", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/VariableContext;)V", "create", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "kotlin.jvm.PlatformType", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "createNameMapper", "Lcom/intellij/javascript/debugger/NameMapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "evaluate", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getEvaluationInfoBySourceMap", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "vm", "Lorg/jetbrains/debugger/Vm;", "script", "Lorg/jetbrains/debugger/Script;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getExpressionInfoAtOffsetAsync", "project", "Lcom/intellij/openapi/project/Project;", "offset", "", "sideEffectsAllowed", "", "getPreferredScript", "JavaScriptDebugger"})
public class ChromeEvaluator
extends PromiseDebuggerEvaluator
implements ExpressionInfoFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        LanguageConsoleView languageConsoleView;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        if (!debugProcess.checkCanPerformCommands()) {
            return Promises.resolvedPromise();
        }
        ConsoleView consoleView = debugProcess.getSession().getConsoleView();
        if (!(consoleView instanceof LanguageConsoleView)) {
            consoleView = null;
        }
        if (((languageConsoleView = (LanguageConsoleView)consoleView) != null && (languageConsoleView = languageConsoleView.getHistoryViewer()) != null ? languageConsoleView.getDocument() : null) == document) {
            GlobalEvaluator evaluator = debugProcess.getGlobalEvaluator();
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = evaluator.getValues();
            synchronized (segmentListWithData) {
                int rangeIndex;
                block10: {
                    rangeIndex = evaluator.getValues().getRangeIndex(offset);
                    if (rangeIndex != -1) break block10;
                    Promise promise = Promises.resolvedPromise();
                    return promise;
                }
                Promise promise = Promises.resolvedPromise((Object)new ExpressionInfo(evaluator.getValues().createRange(rangeIndex), (String)evaluator.getValues().getValueByIndex(rangeIndex).getFirst()));
                return promise;
            }
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return Promises.resolvedPromise();
        }
        PsiFile file = psiFile;
        JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.Companion.getEP_NAME().getExtensions();
        for (int i = 0; i < javaScriptDebugAwareArray.length; ++i) {
            Promise promise;
            PsiElement element;
            JavaScriptDebugAware debugAware = javaScriptDebugAwareArray[i];
            PsiFile psiFile2 = file;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
            if (!debugAware.canGetEvaluationInfo(psiFile2)) continue;
            if (file.findElementAt(offset) == null) {
                return Promises.resolvedPromise();
            }
            PsiElement psiElement = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"element");
            Promise promise2 = debugAware.getEvaluationInfo(psiElement, document, (ExpressionInfoFactory)this);
            if (promise2 == null) continue;
            Promise it = promise = promise2;
            return it;
        }
        return Promises.resolvedPromise((Object)JSDebuggerSupportUtils.getExpressionAtOffset((Document)document, (PsiFile)file, (int)offset));
    }

    @NotNull
    public Promise<ExpressionInfo> create(@NotNull PsiElement element, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> javaScriptDebugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        return this.getEvaluationInfoBySourceMap(element, document, javaScriptDebugProcess, virtualFile).then(new Function<T, SUB_RESULT>(element){
            final /* synthetic */ PsiElement $element;

            @NotNull
            public final ExpressionInfo fun(@Nullable ExpressionInfo it) {
                ExpressionInfo expressionInfo = it;
                if (expressionInfo == null) {
                    expressionInfo = new ExpressionInfo(this.$element.getTextRange());
                }
                return expressionInfo;
            }
            {
                this.$element = psiElement;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NameMapper createNameMapper(@NotNull VirtualFile file, @NotNull Document document) {
        void result;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        List<Url> urls = debugProcess.getFinder().getRemoteUrls(file);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Project project = debugProcess.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
        Lazy<SourceFileResolver> resolver = SourceMapHelperKt.createResolver(project, file);
        Function1 processor2 = (Function1)new Function1<Script, Boolean>(urls, file, resolver, (Ref.ObjectRef)result, debugProcess, document){
            final /* synthetic */ List $urls;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Lazy $resolver;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;
            final /* synthetic */ Document $document;

            public final boolean invoke(@NotNull Script script) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                SourceMap map = script.getSourceMap();
                SourceMap sourceMap = map;
                if (sourceMap != null && (sourceMap = sourceMap.findSourceMappings(this.$urls, this.$file, this.$resolver, false)) != null) {
                    JavaScriptNameMapper javaScriptNameMapper;
                    SourceMap sourceMap2;
                    SourceMap mappingList = sourceMap2 = sourceMap;
                    Ref.ObjectRef objectRef = this.$result;
                    VirtualFile virtualFile = JavaScriptDebugProcess.findFile$default(this.$debugProcess, script.getUrl(), false, 2, null);
                    if (virtualFile != null) {
                        JavaScriptNameMapper javaScriptNameMapper2;
                        VirtualFile virtualFile2 = virtualFile;
                        Ref.ObjectRef objectRef2 = objectRef;
                        VirtualFile file = virtualFile2;
                        Document document = FileDocumentManager.getInstance().getDocument(file);
                        if (document != null) {
                            Document document2;
                            Document it;
                            Document document3 = it = (document2 = document);
                            Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"it");
                            javaScriptNameMapper2 = new JavaScriptNameMapper(this.$document, document3, (Mappings)mappingList, map, file);
                        } else {
                            javaScriptNameMapper2 = null;
                        }
                        JavaScriptNameMapper javaScriptNameMapper3 = javaScriptNameMapper2;
                        objectRef = objectRef2;
                        javaScriptNameMapper = javaScriptNameMapper3;
                    } else {
                        javaScriptNameMapper = null;
                    }
                    objectRef.element = javaScriptNameMapper;
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
            {
                this.$urls = list;
                this.$file = virtualFile;
                this.$resolver = lazy;
                this.$result = objectRef;
                this.$debugProcess = javaScriptDebugProcess;
                this.$document = document;
                super(1);
            }
        };
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        if (preferredScript == null) {
            Vm vm = debugProcess.getActiveOrMainVm();
            if (vm != null && (vm = vm.getScriptManager()) != null) {
                vm.forEachScript(processor2);
            }
        } else {
            processor2.invoke((Object)preferredScript);
        }
        return (NameMapper)result.element;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(PsiElement element, Document document, JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        Iterator iterator;
        int elementOffset = element.getTextOffset();
        int line = document.getLineNumber(elementOffset);
        int elementColumn = elementOffset - document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element.getTextLength() - 1;
        MultiMap scriptToMappings = MultiMap.createLinked();
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        SourceEntriesProcessor processor2 = new SourceEntriesProcessor(elementColumn, elementEndColumn, scriptToMappings){
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ MultiMap $scriptToMappings;

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                int entryColumn = entry.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : this.$elementColumn <= (n = entryColumn) && n <= this.$elementEndColumn;
                if (bl) {
                    this.$scriptToMappings.putValue(ObjectUtils.chooseNotNull((Object)this.getScript(), (Object)this.getScriptUrl()), (Object)entry);
                }
                return true;
            }
            {
                this.$elementColumn = $captured_local_variable$0;
                this.$elementEndColumn = $captured_local_variable$1;
                this.$scriptToMappings = $captured_local_variable$2;
            }
        };
        List<Url> sourceUrls = debugProcess.getFinder().getRemoteUrls(file);
        if (preferredScript == null || preferredScript.getSourceMap() == null) {
            SourceMapHelperKt.processMappingsInLine(debugProcess, debugProcess.getActiveOrMainVm(), sourceUrls, file, line, processor2);
        } else {
            processor2.setScriptUrl(preferredScript.getUrl());
            SourceMap sourceMap = preferredScript.getSourceMap();
            if (sourceMap == null) {
                Intrinsics.throwNpe();
            }
            MappingsProcessorInLine mappingsProcessorInLine = processor2;
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            sourceMap.processSourceMappingsInLine(sourceUrls, line, mappingsProcessorInLine, file, SourceMapHelperKt.createResolver(project, file), false);
            processor2.setScriptUrl(null);
        }
        if (scriptToMappings.isEmpty()) {
            return Promises.resolvedPromise();
        }
        Iterator iterator2 = iterator = scriptToMappings.entrySet().iterator();
        while (iterator2.hasNext()) {
            Vm vm;
            Script script;
            Object k;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            Object key = entry2.getKey();
            entry2 = entry;
            Collection value = (Collection)entry2.getValue();
            if (debugProcess.getActiveOrMainVm() == null) {
                Intrinsics.throwNpe();
            }
            if (!((k = key) instanceof Script)) {
                k = null;
            }
            if ((script = (Script)k) == null) {
                Object k2 = key;
                if (k2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                script = vm.getScriptManager().findScriptByUrl((Url)k2);
            }
            if (script == null) {
                continue;
            }
            Script script2 = script;
            Collection collection = value;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.debugger.sourcemap.MappingEntry>");
            }
            Promise<ExpressionInfo> expressionInfo = this.getEvaluationInfoBySourceMap(vm, element, script2, (List)collection);
            if (expressionInfo == null) continue;
            return expressionInfo;
        }
        return Promises.resolvedPromise();
    }

    private final Script getPreferredScript(JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        CallFrameView topFrameView = (CallFrameView)debugProcess.getSession().getCurrentStackFrame();
        if (topFrameView != null) {
            SourceInfo topFrameSourceInfo;
            SourceInfo sourceInfo = topFrameSourceInfo = topFrameView.getSourcePosition();
            if (Intrinsics.areEqual((Object)(sourceInfo != null ? sourceInfo.getFile() : null), (Object)file)) {
                return topFrameView.getScript();
            }
        }
        return null;
    }

    private final Promise<ExpressionInfo> getEvaluationInfoBySourceMap(Vm vm, PsiElement element, Script script, List<? extends MappingEntry> mappings) {
        boolean isNamedElement = element.getParent() instanceof PsiNamedElement;
        if (mappings.size() > 1 && isNamedElement) {
            NameMapperKt.warnSeveralMapping((PsiElement)element);
            return null;
        }
        Function1<Document, ExpressionInfo> getEvaluationInfo$ = new Function1<Document, ExpressionInfo>(mappings, script, isNamedElement, element){
            final /* synthetic */ List $mappings;
            final /* synthetic */ Script $script;
            final /* synthetic */ boolean $isNamedElement;
            final /* synthetic */ PsiElement $element;

            @NotNull
            public final ExpressionInfo invoke(@NotNull Document rawDocument) {
                Intrinsics.checkParameterIsNotNull((Object)rawDocument, (String)"rawDocument");
                Collections.sort(this.$mappings, SourceMapDecoderKt.getMAPPING_COMPARATOR_BY_GENERATED_POSITION());
                SourceMap sourceMap = this.$script.getSourceMap();
                if (sourceMap == null) {
                    Intrinsics.throwNpe();
                }
                SourceMap sourceMap2 = sourceMap;
                CharSequence charSequence = rawDocument.getImmutableCharSequence();
                StringBuilder expressionBuilder = null;
                CharSequence result = null;
                int n = this.$mappings.size();
                for (int i = 0; i < n; ++i) {
                    MappingEntry nextMapping;
                    MappingEntry mapping = (MappingEntry)this.$mappings.get(i);
                    MappingEntry mappingEntry = nextMapping = i + 1 < n ? (MappingEntry)this.$mappings.get(i + 1) : null;
                    if (nextMapping == null) {
                        nextMapping = sourceMap2.getGeneratedMappings().getNext(mapping);
                    }
                    int generatedLineStartOffset = rawDocument.getLineStartOffset(mapping.getGeneratedLine());
                    int start = generatedLineStartOffset + mapping.getGeneratedColumn();
                    Function1<MappingEntry, Integer> computeEnd$ = new Function1<MappingEntry, Integer>(mapping, rawDocument, generatedLineStartOffset){
                        final /* synthetic */ MappingEntry $mapping;
                        final /* synthetic */ Document $rawDocument;
                        final /* synthetic */ int $generatedLineStartOffset;

                        public final int invoke(@Nullable MappingEntry nextMapping) {
                            return nextMapping == null || nextMapping.getGeneratedLine() != this.$mapping.getGeneratedLine() ? this.$rawDocument.getLineEndOffset(this.$mapping.getGeneratedLine()) : this.$generatedLineStartOffset + nextMapping.getGeneratedColumn();
                        }
                        {
                            this.$mapping = mappingEntry;
                            this.$rawDocument = document;
                            this.$generatedLineStartOffset = n;
                            super(1);
                        }
                    };
                    int end = computeEnd$.invoke(nextMapping);
                    if (nextMapping != null) {
                        if (start > end) {
                            JavaScriptDebugProcessKt.getLOG().assertTrue(nextMapping.getGeneratedColumn() >= mapping.getGeneratedColumn());
                        } else if (this.$isNamedElement && start == end) {
                            MappingEntry m = nextMapping;
                            while (start == (end = computeEnd$.invoke(m = sourceMap2.getGeneratedMappings().getNext(m))) && m != null) {
                            }
                        }
                    }
                    CharSequence name = charSequence.subSequence(start, end);
                    if (this.$isNamedElement) {
                        result = JavaScriptNameMapperKt.doExtractName(name);
                        break;
                    }
                    if (expressionBuilder == null) {
                        expressionBuilder = new StringBuilder();
                        result = expressionBuilder;
                    }
                    if (name.length() == 1 && name.charAt(0) == '.') {
                        expressionBuilder.append('.');
                        continue;
                    }
                    expressionBuilder.append(NameMapper.Companion.trimName(name, i + 1 == n));
                }
                TextRange textRange = this.$element.getTextRange();
                CharSequence charSequence2 = result;
                if (charSequence2 == null) {
                    Intrinsics.throwNpe();
                }
                return new ExpressionInfo(textRange, ((Object)charSequence2).toString(), null);
            }
            {
                this.$mappings = list;
                this.$script = script;
                this.$isNamedElement = bl;
                this.$element = psiElement;
                super(1);
            }
        };
        return ScriptsKt.getResolvedFile(script, vm).then(new Function<T, SUB_RESULT>(getEvaluationInfo$){
            final /* synthetic */ getEvaluationInfoBySourceMap.1 $getEvaluationInfo;

            @NotNull
            public final ExpressionInfo fun(VirtualFile it) {
                VirtualFile virtualFile = it;
                if (virtualFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.testFramework.LightVirtualFile");
                }
                return this.$getEvaluationInfo.invoke((Document)new DocumentImpl(((LightVirtualFile)virtualFile).getContent(), true));
            }
            {
                this.$getEvaluationInfo = var1_1;
            }
        });
    }

    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Promise promise;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Promise promise2 = null;
        if (this.getContext() instanceof CallFrameView) {
            for (Scope scope : ((CallFrameView)this.getContext()).getCallFrame().getVariableScopes()) {
                if (!Intrinsics.areEqual((Object)scope.getType(), (Object)ScopeType.LOCAL)) continue;
                promise2 = ((CallFrameView)this.getContext()).getMemberFilter(scope).thenAsync(new Function<T, Promise<SUB_RESULT>>(this, expression){
                    final /* synthetic */ ChromeEvaluator this$0;
                    final /* synthetic */ String $expression;

                    @NotNull
                    public final Promise<EvaluateResult> fun(MemberFilter it) {
                        EvaluateContext evaluateContext = ChromeEvaluator.access$getContext$p(this.this$0).getEvaluateContext();
                        String string = it.sourceNameToRaw(this.$expression);
                        if (string == null) {
                            string = this.$expression;
                        }
                        return EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)string, null, (boolean)false, (int)6, null);
                    }
                    {
                        this.this$0 = chromeEvaluator;
                        this.$expression = string;
                    }
                });
                break;
            }
            if (((CallFrameView)this.getContext()).getCallFrame().isFromAsyncStack()) {
                return Promises.rejectedPromise((String)"Can't be evaluated in async context");
            }
        }
        if ((promise = promise2) == null) {
            promise = super.evaluate(expression, expressionPosition);
        }
        return promise;
    }

    public ChromeEvaluator(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getContext$p(ChromeEvaluator $this) {
        return $this.getContext();
    }
}

