/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.browserConnection.BrowserConnectionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017JH\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J$\u0010 \u001a\u0010\u0012\f\u0012\n \"*\u0004\u0018\u00010\f0\f0!2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "getBrowserFamily", "()Lcom/intellij/ide/browsers/BrowserFamily;", "checkAvailability", "", "project", "Lcom/intellij/openapi/project/Project;", "createDebugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "fileFinder", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "initialUrl", "Lcom/intellij/util/Url;", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "usePreliminaryPage", "", "isBrowserSupported", "isPreferredEngineForFile", "file", "Lcom/intellij/psi/PsiFile;", "prepareDebugger", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Companion", "JavaScriptDebugger"})
public abstract class JavaScriptDebugEngine {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract JavaScriptDebugProcess<? extends VmConnection<?>> createDebugProcess(@NotNull XDebugSession var1, @NotNull WebBrowser var2, @NotNull DebuggableFileFinder var3, @Nullable Url var4, @Nullable ExecutionResult var5, boolean var6);

    @NotNull
    public final Promise<Unit> prepareDebugger(@NotNull Project project, @NotNull WebBrowser browser) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        return BrowserConnectionManager.getInstance().ensureExtensionInstalled(browser, project).then(new Function<T, SUB_RESULT>(browser, project){
            final /* synthetic */ WebBrowser $browser;
            final /* synthetic */ Project $project;

            public final void fun(Object it) {
                BrowserConnectionManager.getInstance().launchBrowser(this.$browser, this.$project);
            }
            {
                this.$browser = webBrowser;
                this.$project = project;
            }
        });
    }

    @Nullable
    public WebBrowser getBrowser() {
        return WebBrowserManager.getInstance().getFirstBrowserOrNull(this.getBrowserFamily());
    }

    @NotNull
    public abstract BrowserFamily getBrowserFamily();

    public void checkAvailability(@NotNull Project project) throws RuntimeConfigurationError {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
    }

    public boolean isBrowserSupported(@NotNull WebBrowser browser) {
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        return Intrinsics.areEqual((Object)browser.getFamily(), (Object)this.getBrowserFamily());
    }

    protected boolean isPreferredEngineForFile(@NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return false;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebugEngine$Companion;", "", "()V", "findByBrowser", "Lcom/intellij/javascript/debugger/JavaScriptDebugEngine;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "findByBrowserIdOrName", "Lcom/intellij/openapi/util/Pair;", "browserIdOrName", "", "getPreferredBrowser", "file", "Lcom/intellij/psi/PsiFile;", "JavaScriptDebugger"})
    public static final class Companion {
        @Nullable
        public final Pair<JavaScriptDebugEngine, WebBrowser> findByBrowserIdOrName(@NotNull String browserIdOrName) {
            Pair pair;
            Intrinsics.checkParameterIsNotNull((Object)browserIdOrName, (String)"browserIdOrName");
            WebBrowser browser = WebBrowserManager.getInstance().findBrowserById(browserIdOrName);
            if (browser == null) {
                int n = 0;
                Object[] $receiver$iv = JavaScriptDebugEngineKt.getEngines();
                if (n < $receiver$iv.length) {
                    Object file$iv = $receiver$iv[n];
                    JavaScriptDebugEngine engine = (JavaScriptDebugEngine)file$iv;
                    if (JavaScriptDebugEngineKt.access$checkByBrowserIdOrName(engine, browserIdOrName)) {
                        WebBrowser webBrowser = engine.getBrowser();
                        if (webBrowser != null) {
                            WebBrowser webBrowser2;
                            WebBrowser it = webBrowser2 = webBrowser;
                            return Pair.create((Object)engine, (Object)it);
                        }
                    }
                    return null;
                }
                return null;
            }
            JavaScriptDebugEngine javaScriptDebugEngine = this.findByBrowser(browser);
            if (javaScriptDebugEngine != null) {
                JavaScriptDebugEngine javaScriptDebugEngine2;
                JavaScriptDebugEngine it = javaScriptDebugEngine2 = javaScriptDebugEngine;
                pair = Pair.create((Object)it, (Object)browser);
            } else {
                pair = null;
            }
            return pair;
        }

        @Nullable
        public final JavaScriptDebugEngine findByBrowser(@NotNull WebBrowser browser) {
            JavaScriptDebugEngine javaScriptDebugEngine;
            Object object;
            JavaScriptDebugEngine it;
            Object object2;
            int n;
            Object[] objectArray;
            Object[] objectArray2;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
                objectArray = objectArray2 = (Object[])JavaScriptDebugEngineKt.getEngines();
                for (n = 0; n < objectArray.length; ++n) {
                    object2 = objectArray[n];
                    it = (JavaScriptDebugEngine)object2;
                    if (!Intrinsics.areEqual((Object)browser, (Object)it.getBrowser())) continue;
                    object = object2;
                    break block3;
                }
                object = null;
            }
            if ((javaScriptDebugEngine = (JavaScriptDebugEngine)object) == null) {
                Object object3;
                block4: {
                    objectArray = objectArray2 = (Object[])JavaScriptDebugEngineKt.getEngines();
                    for (n = 0; n < objectArray.length; ++n) {
                        object2 = objectArray[n];
                        it = (JavaScriptDebugEngine)object2;
                        if (!it.isBrowserSupported(browser)) continue;
                        object3 = object2;
                        break block4;
                    }
                    object3 = null;
                }
                javaScriptDebugEngine = (JavaScriptDebugEngine)object3;
            }
            return javaScriptDebugEngine;
        }

        @Nullable
        public final WebBrowser getPreferredBrowser(@NotNull PsiFile file) {
            Object object;
            block1: {
                Object[] objectArray;
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Object[] objectArray2 = objectArray = (Object[])JavaScriptDebugEngineKt.getEngines();
                for (int i = 0; i < objectArray2.length; ++i) {
                    Object object2 = objectArray2[i];
                    JavaScriptDebugEngine it = (JavaScriptDebugEngine)object2;
                    if (!it.isPreferredEngineForFile(file)) continue;
                    object = object2;
                    break block1;
                }
                object = null;
            }
            JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)object;
            return javaScriptDebugEngine != null ? javaScriptDebugEngine.getBrowser() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

