/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointProperties;
import com.intellij.javascript.debugger.breakpoints.JavaScriptExceptionBreakpointPropertiesPanel;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptExceptionBreakpointType
extends XBreakpointType<XBreakpoint<JavaScriptExceptionBreakpointProperties>, JavaScriptExceptionBreakpointProperties> {
    public JavaScriptExceptionBreakpointType() {
        super("javascript-exception", JSDebuggerBundle.message("javascript.exception.breakpoints.title", new Object[0]));
    }

    public String getDisplayText(XBreakpoint<JavaScriptExceptionBreakpointProperties> breakpoint) {
        String name = ((JavaScriptExceptionBreakpointProperties)breakpoint.getProperties()).getExceptionName();
        return name != null ? name : "Any exception";
    }

    public JavaScriptExceptionBreakpointProperties createProperties() {
        return new JavaScriptExceptionBreakpointProperties();
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public XBreakpoint<JavaScriptExceptionBreakpointProperties> addBreakpoint(Project project, JComponent parentComponent) {
        String name = Messages.showInputDialog((Project)project, (String)"Enter exception name: ", (String)"Add Exception Breakpoint", null);
        if (name == null) {
            return null;
        }
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new JavaScriptExceptionBreakpointProperties(name)));
    }

    public XBreakpoint<JavaScriptExceptionBreakpointProperties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<JavaScriptExceptionBreakpointProperties> creator) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointType", "createDefaultBreakpoint"));
        }
        return creator.createBreakpoint((XBreakpointProperties)new JavaScriptExceptionBreakpointProperties());
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XBreakpoint<JavaScriptExceptionBreakpointProperties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointType", "createCustomPropertiesPanel"));
        }
        return new JavaScriptExceptionBreakpointPropertiesPanel();
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointType", "getEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointType", "getDisabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_dep_exception_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/breakpoints/JavaScriptExceptionBreakpointType", "getInactiveDependentIcon"));
        }
        return icon;
    }
}

