/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugEngine;
import com.intellij.javascript.debugger.JavaScriptDebugEngineKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfigurationProducerKt;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementAdapter;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class JavaScriptDebugConfiguration
extends LocatableConfigurationBase
implements RefactoringListenerProvider,
RunProfileWithCompileBeforeLaunchOption {
    private String uri;
    private String engineId;
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false)
    private List<RemoteUrlMappingBean> mappings;

    public JavaScriptDebugConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "<init>"));
        }
        super(project, factory, name);
        this.mappings = new SmartList();
    }

    @Attribute
    @Nullable
    public String getUri() {
        return this.uri;
    }

    public void setUri(@Nullable String value) {
        this.uri = StringUtil.isEmptyOrSpaces((String)value) ? null : value.trim();
    }

    @NotNull
    public List<RemoteUrlMappingBean> getMappings() {
        List<RemoteUrlMappingBean> list = this.mappings;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "getMappings"));
        }
        return list;
    }

    public void setMappings(@NotNull List<RemoteUrlMappingBean> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "setMappings"));
        }
        this.mappings = mappings;
    }

    @Attribute
    @Nullable
    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(@Nullable String browserId) {
        this.engineId = StringUtil.nullize((String)browserId);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        JavaScriptDebugSettingsEditor javaScriptDebugSettingsEditor = new JavaScriptDebugSettingsEditor(this.getProject());
        if (javaScriptDebugSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "getConfigurationEditor"));
        }
        return javaScriptDebugSettingsEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaScriptDebugEngine engine;
        if (StringUtil.isEmptyOrSpaces((String)this.uri)) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("javascript.debugger.url.is.not.specified", new Object[0]));
        }
        if (this.engineId != null && (engine = JavaScriptDebugEngineKt.findByBrowserIdOrNameOrEngineId(this.engineId)) != null) {
            engine.checkAvailability(this.getProject());
        }
        if (URLUtil.containsScheme((String)this.uri)) {
            return;
        }
        VirtualFile file = LocalFileFinder.findFile((String)VirtualFileManager.extractPath((String)UriUtil.trimParameters((String)this.uri)));
        if (file == null) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("javascript.debugger.file.not.found", new Object[0]));
        }
        if (!HtmlUtil.isHtmlFile((VirtualFile)file)) {
            throw new RuntimeConfigurationError(JSDebuggerBundle.message("javascript.debugger.file.not.html", new Object[0]));
        }
    }

    public String suggestedName() {
        if (!StringUtil.isEmpty((String)this.uri)) {
            return PathUtil.getFileName((String)this.uri);
        }
        return null;
    }

    public RunConfiguration clone() {
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)super.clone();
        configuration.uri = this.uri;
        configuration.engineId = this.engineId;
        configuration.mappings = new SmartList(this.mappings);
        return configuration;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration", "getState"));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.uri)) {
            throw new ExecutionException(JSDebuggerBundle.message("javascript.debugger.url.is.not.specified", new Object[0]));
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.setUri(element.getAttributeValue("uri"));
        this.engineId = StringUtil.nullize((String)element.getAttributeValue("engineId"));
        for (Object o : element.getChildren("mapping")) {
            Element mapping = (Element)o;
            String remote = StringUtil.nullize((String)mapping.getAttributeValue("url"));
            String local = StringUtil.nullize((String)mapping.getAttributeValue("local-file"));
            if (local == null || remote == null) continue;
            this.mappings.add(new RemoteUrlMappingBean(local, remote));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JavaScriptDebugConfiguration.serialize(this, element);
    }

    public static void serialize(JavaScriptDebugConfiguration settings, Element element) {
        if (!StringUtil.isEmpty((String)settings.engineId)) {
            element.setAttribute("engineId", settings.engineId);
        }
        if (!StringUtil.isEmpty((String)settings.uri)) {
            element.setAttribute("uri", settings.uri);
        }
        for (RemoteUrlMappingBean mapping : settings.mappings) {
            if (StringUtil.isEmpty((String)mapping.getRemoteUrl()) || StringUtil.isEmpty((String)mapping.localFilePath)) continue;
            Element tag = new Element("mapping");
            tag.setAttribute("url", mapping.getRemoteUrl());
            tag.setAttribute("local-file", mapping.localFilePath);
            element.addContent(tag);
        }
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return false;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.uri == null || !JavaScriptDebugConfigurationProducerKt.isConfigurationFromContext(this, element)) {
            return null;
        }
        return new UndoRefactoringElementAdapter(){

            protected void refactored(@NotNull PsiElement element, @Nullable String oldQualifiedName) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/debugger/execution/JavaScriptDebugConfiguration$1", "refactored"));
                }
                Url url = WebBrowserServiceImpl.getDebuggableUrl((PsiElement)element);
                if (url != null) {
                    JavaScriptDebugConfiguration.this.uri = url.toDecodedForm();
                }
            }
        };
    }

    public String toString() {
        return super.toString() + ", uri: " + this.uri + ", engine: " + this.engineId;
    }
}

