/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JSLanguageLevelGuesser
implements DirectoryProjectConfigurator {
    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/javascript/JSLanguageLevelGuesser", "configureProject"));
        }
        JSRootConfiguration rootConfiguration = JSRootConfiguration.getInstance(project);
        if (baseDir.findChild(".flowconfig") != null) {
            rootConfiguration.storeLanguageLevelAndUpdateCaches(JSLanguageLevel.FLOW);
            return;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(baseDir);
        if (packageJson != null) {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
            boolean seenBabel = false;
            for (String dep : data.getAllDependencies()) {
                if ("react".equals(dep)) {
                    rootConfiguration.storeLanguageLevelAndUpdateCaches(JSLanguageLevel.JSX);
                    return;
                }
                seenBabel |= dep.startsWith("babel");
            }
            if (seenBabel) {
                rootConfiguration.storeLanguageLevelAndUpdateCaches(JSLanguageLevel.ES6);
                return;
            }
        }
        if (baseDir.findChild(".babelrc") != null) {
            rootConfiguration.storeLanguageLevelAndUpdateCaches(JSLanguageLevel.ES6);
            return;
        }
        for (VirtualFile configFile : baseDir.getChildren()) {
            if (!EslintUtil.isEslintConfigFile(configFile) || configFile.getLength() >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            try {
                String text = VfsUtilCore.loadText((VirtualFile)configFile);
                if (!text.contains("\"es6\"") && !text.contains("'es6'")) continue;
                rootConfiguration.storeLanguageLevelAndUpdateCaches(JSLanguageLevel.ES6);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

