/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.resolve.CssClassOrIdReference;
import com.intellij.psi.css.resolve.CssSimpleSelectorReference;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptCssReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/JavaScriptCssReferenceContributor", "registerReferenceProviders"));
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return ((JSLiteralExpression)element).isQuotedLiteral() && JavaScriptReferenceContributor.isLiteralInCssContext((PsiElement)element, true) && JavaScriptCssReferenceContributor.isSimpleCss(StringUtil.unquoteString((String)((PsiElement)element).getText()), true, true);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                }
                String rawText = psiElement.getText();
                String text = StringUtil.unquoteString((String)rawText);
                int offset = JavaScriptReferenceContributor.skipChars(text, false, true);
                if (offset == text.length()) {
                    String name;
                    JSReferenceExpression invokedMethod = JSUtils.getMethodNameIfInsideCall(psiElement.getParent());
                    String string = name = invokedMethod != null ? invokedMethod.getReferencedName() : null;
                    if (name != null && name.contains("Class")) {
                        int end;
                        ArrayList<MyCssClassOrIdReference> result = new ArrayList<MyCssClassOrIdReference>();
                        int start = 0;
                        while (start < text.length() && (end = JavaScriptCssReferenceContributor.skipChars(text, start, false)) != start) {
                            result.add(new MyCssClassOrIdReference(psiElement, CssSelectorSuffixType.CLASS, new TextRange(start + 1, end + 1), false, false));
                            if (end == text.length()) break;
                            start = JavaScriptCssReferenceContributor.skipChars(text, end, true);
                        }
                        PsiReference[] psiReferenceArray = result.isEmpty() ? PsiReference.EMPTY_ARRAY : result.toArray(new PsiReference[result.size()]);
                        if (psiReferenceArray == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                        }
                        return psiReferenceArray;
                    }
                    PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, CssSelectorSuffixType.ID, null, false, false)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (offset == 0 && offset < text.length() && (text.charAt(offset) == '.' || text.charAt(offset) == '#')) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, text.charAt(0) == '#' ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS, null, true, true)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (offset < text.length() && (text.charAt(offset) == '.' || text.charAt(offset) == '#')) {
                    CssSelectorSuffixType selectorType = text.charAt(offset) == '#' ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new CssSimpleSelectorReference(psiElement, new TextRange(1, offset + 1)), new MyCssClassOrIdReference(psiElement, selectorType, new TextRange(offset + 1 + 1, text.length() + 1), true, false)};
                    if (psiReferenceArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptCssReferenceContributor$1", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
        });
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

            public boolean isAcceptable(Object element, PsiElement context) {
                return JavaScriptCssReferenceContributor.isHtmlAttributeReference((PsiElement)element);
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        })), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/JavaScriptCssReferenceContributor$3", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/javascript/JavaScriptCssReferenceContributor$3", "getReferencesByElement"));
                }
                JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(psiElement.getParent());
                CssSelectorSuffixType selectorType = "getElementById".equals(methodExpression.getReferencedName()) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
                PsiReference[] psiReferenceArray = new PsiReference[]{new MyCssClassOrIdReference(psiElement, selectorType, null, false, false)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/JavaScriptCssReferenceContributor$3", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        });
    }

    private static boolean isSimpleCss(String text, boolean allowDotsOrSharps, boolean allowWhiteSpaceSeparators) {
        return JavaScriptReferenceContributor.skipChars(text, allowDotsOrSharps, allowWhiteSpaceSeparators) == text.length();
    }

    private static int skipChars(String text, int start, boolean whiteSpace) {
        int result;
        for (result = start; result < text.length() && whiteSpace == Character.isWhitespace(text.charAt(result)); ++result) {
        }
        return result;
    }

    private static boolean isHtmlAttributeReference(PsiElement element) {
        if (!(element instanceof JSLiteralExpression) || !((JSLiteralExpression)element).isQuotedLiteral()) {
            return false;
        }
        JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(element.getParent());
        if (methodExpression == null) {
            return false;
        }
        String referencedName = methodExpression.getReferencedName();
        return "getElementsByClassName".equals(referencedName) || "getElementById".equals(referencedName);
    }

    private static class MyCssClassOrIdReference
    extends CssClassOrIdReference {
        @NotNull
        private final CssSelectorSuffixType mySelectorType;
        private boolean myHasExplicitIdMark;
        private boolean myHasExplicitClassMark;

        public MyCssClassOrIdReference(PsiElement psiElement, @NotNull CssSelectorSuffixType selectorType, @Nullable TextRange range, boolean hasExplicitIdMark, boolean hasExplicitClassMark) {
            if (selectorType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectorType", "com/intellij/javascript/JavaScriptCssReferenceContributor$MyCssClassOrIdReference", "<init>"));
            }
            super(psiElement, range);
            this.mySelectorType = selectorType;
            this.myHasExplicitIdMark = hasExplicitIdMark;
            this.myHasExplicitClassMark = hasExplicitClassMark;
        }

        protected boolean isId() {
            return this.mySelectorType == CssSelectorSuffixType.ID;
        }

        protected boolean hasExplicitIdMark() {
            return this.myHasExplicitIdMark;
        }

        protected boolean hasExplicitClassMark() {
            return this.myHasExplicitClassMark;
        }
    }
}

