/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionModuleInfo {
    private final String myName;
    private final VirtualFile myVirtualFile;
    private final ModuleType myType;

    public CompletionModuleInfo(@NotNull String name, @Nullable VirtualFile fileOrDir, @NotNull ModuleType type) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/CompletionModuleInfo", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/nodejs/CompletionModuleInfo", "<init>"));
        }
        this.myName = name;
        this.myVirtualFile = fileOrDir;
        this.myType = type;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/CompletionModuleInfo", "getName"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @NotNull
    public ModuleType getType() {
        ModuleType moduleType = this.myType;
        if (moduleType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/CompletionModuleInfo", "getType"));
        }
        return moduleType;
    }

    @Nullable
    public String getAbsolutePath() {
        if (this.myVirtualFile == null) {
            return null;
        }
        return this.myVirtualFile.getPath();
    }

    @Nullable
    public String getPresentablePath(@Nullable VirtualFile requester) {
        VirtualFile parent;
        String path = this.getAbsolutePath();
        if (path == null) {
            return null;
        }
        String systemDependentAbsolutePath = FileUtil.toSystemDependentName((String)path);
        if (requester != null && this.myType != ModuleType.GLOBAL_FOLDER && (parent = requester.getParent()) != null) {
            String systemDependentDirPath = FileUtil.toSystemDependentName((String)parent.getPath());
            return FileUtil.getRelativePath((String)systemDependentDirPath, (String)systemDependentAbsolutePath, (char)File.separatorChar);
        }
        return systemDependentAbsolutePath;
    }
}

