/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesPredefinedLibraryProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(NodeModulesPredefinedLibraryProvider.class);

    @Override
    @NotNull
    public ScriptingLibraryModel[] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        NodeModulesDirectoryManager manager = NodeModulesDirectoryManager.getInstance(project);
        List<NodeModulesLibraryDirectory> nodeModulesDirs = manager.getNodeModulesDirectories();
        List models = ContainerUtil.mapNotNull(nodeModulesDirs, nodeModulesDir -> NodeModulesPredefinedLibraryProvider.createLibraryModel(nodeModulesDir));
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryModel.toArray((Collection)models);
        if (scriptingLibraryModelArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "getPredefinedLibraries"));
        }
        return scriptingLibraryModelArray;
    }

    @Nullable
    private static ScriptingLibraryModel createLibraryModel(@NotNull NodeModulesLibraryDirectory libraryDir) {
        if (libraryDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDir", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider", "createLibraryModel"));
        }
        if (!libraryDir.getNodeModulesDir().isValid()) {
            LOG.warn("Cannot create library as " + libraryDir.getNodeModulesDir().getPath() + " is invalid");
            return null;
        }
        if (libraryDir.isForApplicationSourceCode()) {
            return null;
        }
        return new NodeModulesLibraryModel(libraryDir);
    }

    private static class NodeModulesLibraryModel
    extends ScriptingLibraryModel
    implements ScriptingLibraryModelBackedBySyntheticLibrary {
        private final VirtualFile myNodeModulesDir;

        public NodeModulesLibraryModel(@NotNull NodeModulesLibraryDirectory libraryDir) {
            if (libraryDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryDir", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "<init>"));
            }
            super(libraryDir.getLibraryName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.PREDEFINED, false);
            this.myNodeModulesDir = libraryDir.getNodeModulesDir();
        }

        @NotNull
        public Set<VirtualFile> getSourceFiles() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "getSourceFiles"));
            }
            return set;
        }

        public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "collectFilesWithGlobalDefinitions"));
            }
        }

        public boolean shouldIndexSourcesWithoutMappings() {
            return false;
        }

        @NotNull
        public List<VirtualFile> getDefaultMappings() {
            List<VirtualFile> list = Collections.singletonList(this.myNodeModulesDir.getParent());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "getDefaultMappings"));
            }
            return list;
        }

        @NotNull
        public VirtualFile getLibraryRoot() {
            VirtualFile virtualFile = this.myNodeModulesDir;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/library/NodeModulesPredefinedLibraryProvider$NodeModulesLibraryModel", "getLibraryRoot"));
            }
            return virtualFile;
        }
    }
}

