/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.buildTools.webpack.WebPackReferenceContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.typescript.intentions.TypeScriptImportAction;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.psi.TypeScriptAutoImportUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CreateImportUtil {
    private static final TokenSet EXPORT_ELEMENT_TYPES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION});

    public static boolean checkSymbolInFile(@NotNull Project project, @NotNull VirtualFile fileToCheck, @NotNull JSElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInFile"));
        }
        if (fileToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToCheck", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInFile"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInFile"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInFile"));
        }
        PsiFile possiblePsiFile = PsiManager.getInstance((Project)project).findFile(fileToCheck);
        if (!(possiblePsiFile instanceof JSFile)) {
            return false;
        }
        JSFile file = (JSFile)possiblePsiFile;
        if (!(elementToImport instanceof JSQualifiedNamedElement)) {
            return elementToImport instanceof PsiFile && possiblePsiFile.isEquivalentTo((PsiElement)elementToImport);
        }
        return ES6CreateImportUtil.checkSymbolInModule((JSQualifiedNamedElement)elementToImport, place, (JSElement)file);
    }

    public static boolean checkSymbolInModule(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInModule"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolInModule"));
        }
        return ES6CreateImportUtil.getSymbolInModule(elementToImport, place, module) != null;
    }

    @Nullable
    public static ResolveResult getSymbolInModule(@NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place, @NotNull JSElement module) {
        ResolveResult[] results;
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getSymbolInModule"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getSymbolInModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getSymbolInModule"));
        }
        String name = elementToImport.getQualifiedName();
        if (name == null) {
            return null;
        }
        ResolveResultSink sink = new ResolveResultSink(place, name, true);
        JSDialectSpecificHandlersFactory factory = JSDialectSpecificHandlersFactory.forElement((PsiElement)module);
        QualifiedItemProcessor<ResolveResultSink> processor = factory.createQualifiedItemProcessor(sink, place);
        ES6PsiUtil.processExportDeclarationInScope(module, processor, ResolveState.initial(), place);
        for (ResolveResult result : results = sink.getResultsAsResolveResults()) {
            PsiElement element;
            if (!result.isValidResult() || (element = result.getElement()) == null || !element.isEquivalentTo((PsiElement)elementToImport)) continue;
            return result;
        }
        return null;
    }

    @Nullable
    static VirtualFile resolveAsNpmPackage(@NotNull Project project, @NotNull VirtualFile pathFile, @NotNull PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "resolveAsNpmPackage"));
        }
        if (pathFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "resolveAsNpmPackage"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "resolveAsNpmPackage"));
        }
        NodeModuleDirectorySearchProcessor processor = DialectDetector.isTypeScript(context) ? new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(project) : NodeModuleDirectorySearchProcessor.PROCESSOR;
        return JSExactFileReference.resolveForNpmPackages(pathFile, processor, false);
    }

    @Nullable
    public static VirtualFile checkSymbolAndGetFile(@NotNull Project project, @NotNull VirtualFile dstFile, @NotNull VirtualFile pathFile, @NotNull PsiElement place, @Nullable JSElement elementToImport) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolAndGetFile"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolAndGetFile"));
        }
        if (pathFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolAndGetFile"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "checkSymbolAndGetFile"));
        }
        if (pathFile.isDirectory()) {
            VirtualFile possibleFile = ES6CreateImportUtil.resolveAsNpmPackage(project, pathFile, (PsiElement)(elementToImport == null ? place : elementToImport));
            if (possibleFile == null) {
                return null;
            }
            pathFile = possibleFile;
        }
        if (pathFile.equals(dstFile)) {
            return pathFile;
        }
        if (elementToImport == null) {
            return null;
        }
        if (ES6CreateImportUtil.checkSymbolInFile(project, pathFile, elementToImport, place)) {
            return pathFile;
        }
        return null;
    }

    @Nullable
    public static Pair<VirtualFile, VirtualFile> findParentLibraryDirectory(@NotNull Project project, @NotNull VirtualFile dstFile, @NotNull String[] directories) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "findParentLibraryDirectory"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "findParentLibraryDirectory"));
        }
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "findParentLibraryDirectory"));
        }
        VirtualFile prevDirectory = null;
        VirtualFile prevDirectoryWithPackageJson = null;
        Object[] stopDirs = ProjectRootManager.getInstance((Project)project).getContentRoots();
        for (VirtualFile currentDirectory = dstFile.getParent(); currentDirectory != null; currentDirectory = currentDirectory.getParent()) {
            if (ArrayUtil.contains((String)currentDirectory.getName(), (String[])directories)) {
                VirtualFile module = prevDirectoryWithPackageJson == null ? prevDirectory : prevDirectoryWithPackageJson;
                return Pair.create(module, (Object)currentDirectory);
            }
            if (ArrayUtil.contains((Object)currentDirectory, (Object[])stopDirs)) break;
            if (null != currentDirectory.findChild("package.json")) {
                prevDirectoryWithPackageJson = currentDirectory;
            }
            prevDirectory = currentDirectory;
        }
        return null;
    }

    public static GlobalSearchScope createSymbolToImportSearchScope(final @NotNull Project project, @NotNull PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "createSymbolToImportSearchScope"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "createSymbolToImportSearchScope"));
        }
        if (DialectDetector.isTypeScript(context)) {
            return TypeScriptAutoImportUtil.createSymbolToImportSearchScope(project, context);
        }
        final ProjectFileIndex instance = ProjectFileIndex.getInstance((Project)project);
        return new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope(context)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$1", "contains"));
                }
                if (!super.contains(file)) {
                    return false;
                }
                return !JSLibraryUtil.isProbableLibraryFile(file, project) && !instance.isInLibrary(file);
            }
        };
    }

    public static boolean isAvailableForImport(@NotNull PsiElement candidate, @NotNull PsiElement context) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "isAvailableForImport"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "isAvailableForImport"));
        }
        return ES6CreateImportUtil.isAvailableForImport(candidate, new JSImportPlaceInfo(context.getOriginalElement()));
    }

    public static ES6ImportAction createImportAction(@Nullable Editor editor, @NotNull PsiElement context, @Nullable String name, @Nullable JSQualifiedNamedElement toImport, @NotNull ES6ImportAction.ImportElementFilter filter) {
        PsiElement module;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "createImportAction"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "createImportAction"));
        }
        if (DialectDetector.isTypeScript(context)) {
            return new TypeScriptImportAction(editor, context, name, filter);
        }
        if (toImport != null && DialectDetector.isTypeScript((PsiElement)toImport) && (module = ES6PsiUtil.findExternalModule((PsiElement)toImport)) instanceof TypeScriptModule) {
            return new TypeScriptImportAction(editor, context, name, filter);
        }
        return new ES6ImportAction(editor, context, name, filter);
    }

    public static void insertExport(@NotNull JSQualifiedNamedElement elementToImport, @NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExport"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExport"));
        }
        if (importedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExport"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExport"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSModuleNameInfo moduleNameInfo = ES6CreateImportUtil.getModuleNameInfo(place.getProject(), elementToImport, place);
        if (moduleNameInfo == null) {
            return;
        }
        PsiElement scope = ES6CreateImportUtil.getScopeToAdd(place, true);
        if (scope == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo createInfo = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type, false);
        ES6ImportExportDeclaration exportDeclaration = ES6ImportPsiUtil.createImportExport(place, createInfo, moduleNameInfo.getPath());
        if (exportDeclaration == null) {
            return;
        }
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope((PsiElement)exportDeclaration, scope, placeForAnchor, null);
    }

    public static void insertExportName(@NotNull ES6ImportPsiUtil.ImportExportType type, @NotNull String importedName, @Nullable String exportedName, @NotNull PsiElement place) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExportName"));
        }
        if (importedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedName", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExportName"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertExportName"));
        }
        PsiElement scope = ES6CreateImportUtil.getScopeToAdd(place, true);
        if (scope == null) {
            return;
        }
        ES6ImportPsiUtil.CreateImportExportInfo info = new ES6ImportPsiUtil.CreateImportExportInfo(exportedName, importedName, type, true);
        StringBuilder builder = new StringBuilder("export ");
        if (type == ES6ImportPsiUtil.ImportExportType.DEFAULT) {
            builder.append("default ");
        }
        builder.append(info.getRawText(JSCodeStyleSettings.getSettings((PsiElement)place).SPACES_WITHIN_IMPORTS));
        builder.append(JSCodeStyleSettings.getSemicolon(place.getContainingFile()));
        ASTNode importNode = JSChangeUtil.createStatementFromTextWithContext(builder.toString(), place);
        if (importNode == null) {
            return;
        }
        Pair<Boolean, PsiElement> placeForAnchor = ES6ImportPsiUtil.findAnchorToInsert(scope, EXPORT_ELEMENT_TYPES, false);
        ES6CreateImportUtil.insertPsiElementToScope(importNode.getPsi(), scope, placeForAnchor, null);
    }

    public static JSModuleNameInfo getModuleNameInfo(@NotNull Project project, @NotNull JSQualifiedNamedElement elementToImport, @NotNull PsiElement place) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getModuleNameInfo"));
        }
        if (elementToImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToImport", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getModuleNameInfo"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getModuleNameInfo"));
        }
        if (DialectDetector.isTypeScript(place)) {
            return TypeScriptAutoImportUtil.getExternalFileModuleName(project, (JSElement)elementToImport, place);
        }
        VirtualFile placeFile = place.getContainingFile().getVirtualFile();
        PsiFile targetPsiFile = elementToImport.getContainingFile();
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        VirtualFile root = NodeModuleUtil.findMainModuleRoot(project, placeFile);
        if (root == null) {
            return NodeJSModulesSearcher.getES6ModuleNameInfo(place, placeFile, targetFile);
        }
        return NodeJSModulesSearcher.getModuleInfo(place, root, elementToImport.getContainingFile(), ModuleFixCreator.ModuleType.es6, false);
    }

    public static boolean isAvailableForImport(@NotNull PsiElement candidate, @NotNull JSImportPlaceInfo info) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "isAvailableForImport"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "isAvailableForImport"));
        }
        if (DialectDetector.isTypeScript(info.getPlace())) {
            return TypeScriptAutoImportUtil.isAvailableForImport(candidate, info);
        }
        return ES6ImportHandler.isExportedWithNameOrDefault(candidate) && ES6PsiUtil.isExternalModule((PsiElement)candidate.getContainingFile());
    }

    public static void insertImport(@NotNull PsiElement place, @NotNull JSQualifiedNamedElement toImport, @Nullable String importedName) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertImport"));
        }
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertImport"));
        }
        ES6ImportAction action = ES6CreateImportUtil.createImportAction(null, place, importedName, toImport, new ES6ImportAction.ImportElementFilter(){

            @Override
            @NotNull
            public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2", "filterByContext"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2", "filterByContext"));
                }
                List<JSElement> list = result;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2", "filterByContext"));
                }
                return list;
            }

            @Override
            public boolean isValidContext(@NotNull PsiElement context) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil$2", "isValidContext"));
                }
                return true;
            }
        });
        action.executeWithoutPrepare((JSElement)toImport);
    }

    public static PsiElement getExternalModuleScope(@NotNull PsiElement place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getExternalModuleScope"));
        }
        return ES6CreateImportUtil.getScopeToAdd(place, true);
    }

    @Nullable
    public static PsiElement getScopeToAdd(@NotNull PsiElement place, boolean fromExternalModule) {
        JSEmbeddedContent content;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getScopeToAdd"));
        }
        if (!(place.getContainingFile() instanceof JSFile) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)place, JSEmbeddedContent.class)) != null) {
            return content;
        }
        if (fromExternalModule) {
            PsiElement module = ES6PsiUtil.findExternalModule(place);
            return module != null ? module : place.getContainingFile();
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, (Class[])new Class[]{PsiFile.class, TypeScriptModule.class});
    }

    public static void insertPsiElementToScope(final @NotNull PsiElement createdPsi, final @NotNull PsiElement scope, final @NotNull Pair<Boolean, PsiElement> placeFor, final @Nullable Editor editor) {
        if (createdPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdPsi", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertPsiElementToScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertPsiElementToScope"));
        }
        if (placeFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFor", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertPsiElementToScope"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        final PsiFile file = scope.getContainingFile();
        final Project project = scope.getProject();
        new WriteCommandAction.Simple<Void>(project, JSBundle.message((String)"ts.add.import.statement.family.name", (Object[])new Object[0]), new PsiFile[]{file}){

            protected void run() throws Throwable {
                Document document;
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                Document document2 = document = editor != null ? editor.getDocument() : manager.getDocument(file);
                if (document != null) {
                    manager.commitDocument(document);
                }
                if (Boolean.TRUE.equals(placeFor.first)) {
                    scope.addAfter(createdPsi, (PsiElement)placeFor.second);
                } else {
                    scope.addBefore(createdPsi, (PsiElement)placeFor.second);
                }
            }
        }.execute();
    }

    @Nullable
    public static VirtualFile getDirectoryToCalcModuleNameInNodeModules(@NotNull PsiFile placePsiFile, VirtualFile moduleDirectory) {
        VirtualFile parentOfNodeModules;
        VirtualFile directoryToCalcModuleName;
        if (placePsiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placePsiFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getDirectoryToCalcModuleNameInNodeModules"));
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile current = moduleDirectory;
        VirtualFile nodeModulesDirectory = null;
        Object object = directoryToCalcModuleName = "@types".equals(current.getName()) ? current : null;
        while (current != null) {
            if ((current = current.getParent()) == null) continue;
            String name = current.getName();
            if ("@types".equals(name)) {
                directoryToCalcModuleName = current;
                continue;
            }
            if (!"node_modules".equals(current.getName())) continue;
            nodeModulesDirectory = current;
            break;
        }
        if (nodeModulesDirectory == null) {
            return null;
        }
        if (directoryToCalcModuleName == null) {
            directoryToCalcModuleName = nodeModulesDirectory;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)(parentOfNodeModules = nodeModulesDirectory.getParent()), (VirtualFile)placeFile, (boolean)true)) {
            return null;
        }
        return directoryToCalcModuleName;
    }

    @Nullable
    public static JSModuleNameInfo getExternalModuleNameForFile(@NotNull PsiElement place, @NotNull VirtualFile placeFile, @Nullable JSElement toImport, @NotNull VirtualFile dstFile, @Nullable TypeScriptConfig configFile, boolean checkNodeResolution) {
        String externalModuleName;
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getExternalModuleNameForFile"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getExternalModuleNameForFile"));
        }
        if (dstFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dstFile", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "getExternalModuleNameForFile"));
        }
        WebPackReferenceContributor contributor = WebPackReferenceContributor.Companion.getInstance();
        String webpackPath = contributor.getReferencePath(place, dstFile);
        if (!StringUtil.isEmpty((String)webpackPath)) {
            return new JSModuleNameInfo(webpackPath, dstFile, place);
        }
        Project project = place.getProject();
        VirtualFile pathFile = dstFile.getParent();
        VirtualFile resultDest = null;
        if (checkNodeResolution && ES6CreateImportUtil.useNodeResolution(place, configFile) && !Objects.equals(placeFile.getParent(), dstFile.getParent())) {
            resultDest = ES6CreateImportUtil.checkSymbolAndGetFile(project, dstFile, pathFile, place, toImport);
        }
        if (resultDest == null) {
            pathFile = dstFile;
            resultDest = dstFile;
        }
        if (JSCodeStyleSettings.isUseAbsolutePath(place)) {
            String rootPath;
            VirtualFile rootFile = TypeScriptAutoImportUtil.getRootFromConfig(configFile);
            if (rootFile == null && (rootPath = ES6ImportPsiUtil.getPathRelativeToRoots(place, placeFile, dstFile)) != null) {
                return new JSModuleNameInfo(rootPath, dstFile, dstFile, place);
            }
            if (rootFile != null) {
                String path = VfsUtil.getPath((VirtualFile)rootFile, (VirtualFile)pathFile, (char)'/');
                if (path == null) {
                    return new JSModuleNameInfo(VfsUtil.getPath((VirtualFile)rootFile, (VirtualFile)dstFile, (char)'/'), dstFile, dstFile, place);
                }
                return new JSModuleNameInfo(path, resultDest, pathFile, place);
            }
        }
        if ((externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)pathFile, (char)'/')) == null) {
            externalModuleName = VfsUtil.getPath((VirtualFile)placeFile, (VirtualFile)dstFile, (char)'/');
            if (externalModuleName == null) {
                return null;
            }
            pathFile = dstFile;
            resultDest = dstFile;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(File.separator)) {
            externalModuleName = "./" + externalModuleName;
        }
        return new JSModuleNameInfo(externalModuleName, resultDest, pathFile, place);
    }

    private static boolean useNodeResolution(@NotNull PsiElement context, @Nullable TypeScriptConfig config2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "useNodeResolution"));
        }
        if (!JSCodeStyleSettings.isUseNodeResolution(context)) {
            return false;
        }
        if (config2 == null) {
            return true;
        }
        TypeScriptConfig.ModuleResolution resolution = config2.getResolution();
        if (resolution == TypeScriptConfig.ModuleResolution.NODE) {
            return true;
        }
        return TypeScriptConfig.ModuleTarget.COMMON_JS == config2.getModule();
    }

    public static void findPlaceAndInsertImport(@NotNull PsiElement scope, @NotNull PsiElement created, @Nullable Editor editor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "findPlaceAndInsertImport"));
        }
        if (created == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "created", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "findPlaceAndInsertImport"));
        }
        Pair<Boolean, PsiElement> anchor = ES6ImportPsiUtil.findPlaceForImport(scope);
        ES6CreateImportUtil.insertPsiElementToScope(created, scope, anchor, editor);
    }

    public static boolean insertFromClause(final @NotNull ES6ImportDeclaration importDeclaration, @NotNull String quotedRefText) {
        if (importDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDeclaration", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertFromClause"));
        }
        if (quotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quotedRefText", "com/intellij/lang/ecmascript6/psi/impl/ES6CreateImportUtil", "insertFromClause"));
        }
        final PsiElement lastChild = importDeclaration.getLastChild();
        if (lastChild instanceof PsiErrorElement) {
            String currentText = importDeclaration.getText();
            boolean hasCloseBrace = currentText.contains("}");
            String newText = currentText + (hasCloseBrace ? "" : "}") + " from " + quotedRefText + JSCodeStyleSettings.getSemicolon(importDeclaration.getContainingFile());
            Project project = importDeclaration.getProject();
            PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
            PsiFile dummy = psiFileFactory.createFileFromText("dummy", importDeclaration.getContainingFile().getFileType(), (CharSequence)newText);
            final ES6ImportDeclaration declaration = (ES6ImportDeclaration)dummy.getFirstChild();
            ES6FromClause fromClause = declaration.getFromClause();
            assert (fromClause != null) : newText;
            ASTNode closeBrace = declaration.getNode().findChildByType(JSTokenTypes.RBRACE);
            assert (closeBrace != null) : newText;
            final PsiElement startRangeElement = (hasCloseBrace ? closeBrace.getTreeNext() : closeBrace).getPsi();
            assert (startRangeElement != null) : newText;
            new WriteCommandAction.Simple<Void>(project, "Complete import statement", new PsiFile[]{importDeclaration.getContainingFile()}){

                protected void run() throws Throwable {
                    importDeclaration.addRangeAfter(startRangeElement, declaration.getLastChild(), lastChild);
                    lastChild.delete();
                }
            }.execute();
            return true;
        }
        return false;
    }
}

