/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ModuleMemberInfo
extends MemberInfoBase<JSQualifiedNamedElement> {
    public ES6ModuleMemberInfo(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo", "<init>"));
        }
        super((PsiElement)member);
        this.displayName = member.getName();
    }

    public static ES6ModuleMemberInfo create(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo", "create"));
        }
        return new ES6ModuleMemberInfo(element);
    }

    public static List<ES6ModuleMemberInfo> getModuleMembers(@NotNull PsiElement module, @NotNull Collection<JSPsiElementBase> selectedElements) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo", "getModuleMembers"));
        }
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo", "getModuleMembers"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement element : module.getChildren()) {
            JSQualifiedNamedElement candidate = ES6ModuleMemberInfo.getMember(element);
            if (candidate == null || !ES6PsiUtil.isElementCanBeExported((PsiElement)candidate)) continue;
            ES6ModuleMemberInfo el = ES6ModuleMemberInfo.create(candidate);
            if (selectedElements.contains(candidate)) {
                el.setChecked(true);
            }
            result.add(el);
        }
        return result;
    }

    @Nullable
    public static JSQualifiedNamedElement getMember(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo", "getMember"));
        }
        PsiElement candidate = element;
        if (element instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)element).getVariables();
            if (variables.length != 1) {
                return null;
            }
            candidate = variables[0];
        }
        if (element instanceof ES6ExportDefaultAssignment) {
            JSElement defaultElement = ((ES6ExportDefaultAssignment)element).getStubSafeElement();
            return defaultElement instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)defaultElement : null;
        }
        return candidate instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)candidate : null;
    }
}

