/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberSelectionTable;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveSymbolDialog;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersDialog
extends ES6MoveSymbolDialog {
    private final ES6ModuleMemberSelectionTable mySelectionTable;

    public ES6MoveModuleMembersDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull Collection<JSPsiElementBase> selectedElements, @NotNull PsiElement module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog", "<init>"));
        }
        if (fromPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromPath", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog", "<init>"));
        }
        if (toPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toPath", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog", "<init>"));
        }
        if (selectedElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedElements", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog", "<init>"));
        }
        super(project, fromPath, toPath, module);
        this.setTitle(JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]));
        this.mySelectionTable = new ES6ModuleMemberSelectionTable(ES6ModuleMemberInfo.getModuleMembers(module, selectedElements), null);
        JBScrollPane content = new JBScrollPane((Component)((Object)this.mySelectionTable)){

            public Dimension getMinimumSize() {
                return new Dimension((int)super.getMinimumSize().getWidth(), 0);
            }
        };
        this.mySelectionTable.setShowColumns(false);
        this.myExtraPanel.add((Component)content, "North");
        this.init();
    }

    public Collection<JSQualifiedNamedElement> getSelectedElements() {
        return this.mySelectionTable.getSelectedMemberInfos().stream().map(el -> (JSQualifiedNamedElement)el.getMember()).collect(Collectors.toList());
    }

    @Override
    protected void doAction() {
        String message = this.validateData();
        if (message != null) {
            if (message.length() != 0) {
                CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]), (String)message, null, (Project)this.myProject);
            }
            return;
        }
        super.doAction();
    }

    @Nullable
    private String validateData() {
        if (this.getSelectedElements().isEmpty()) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.no.selected.items", (Object[])new Object[0]);
        }
        String modulePath = this.getModuleString();
        if (StringUtil.isEmpty((String)modulePath)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        if (StringUtil.equals((CharSequence)this.myFromField.getText(), (CharSequence)modulePath)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.modules.same", (Object[])new Object[0]);
        }
        Ref result = Ref.create();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                result.set((Object)this.checkOrCreateFile(modulePath));
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)e.getMessage(), null, (Project)this.myProject);
            }
        }, JSBundle.message((String)"es6.move.module.members.refactoring.create.file", (Object[])new Object[0]), null);
        return (String)result.get();
    }

    @Nullable
    private String checkOrCreateFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog", "checkOrCreateFile"));
        }
        path = FileUtil.toSystemIndependentName((String)path);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null) {
            return null;
        }
        String fileName = VfsUtil.extractFileName((String)path);
        String parentDir = VfsUtil.getParentDir((String)path);
        if (parentDir == null || fileName == null || StringUtil.isEmpty((String)FileUtilRt.getExtension((String)fileName))) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        int answer = Messages.showYesNoDialog((Project)this.myProject, (String)JSBundle.message((String)"es6.move.module.members.refactoring.create.file.message", (Object[])new Object[]{fileName}), (String)this.getTitle(), (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            try {
                WriteAction.run(() -> {
                    VirtualFile directories = VfsUtil.createDirectories((String)parentDir);
                    directories.createChildData((Object)this, fileName);
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "";
    }

    public String getModuleString() {
        return this.myModuleField.getText();
    }
}

