/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ES6ReferenceExpressionsInfo {
    public static final ES6ReferenceExpressionsInfo EMPTY = new ES6ReferenceExpressionsInfo(ContainerUtil.emptyList(), ContainerUtil.emptyList(), ContainerUtil.newHashMap());
    @NotNull
    private final Collection<PsiElement> myLocals;
    @NotNull
    private final Collection<PsiElement> myExportedLocals;
    @NotNull
    private final Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> myImports;

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(final @NotNull JSPsiElementBase element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "getInfo"));
        }
        final PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)element);
        if (module == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "getInfo"));
            }
            return eS6ReferenceExpressionsInfo;
        }
        final ArrayList locals = ContainerUtil.newArrayList();
        final ArrayList exportedLocals = ContainerUtil.newArrayList();
        final LinkedHashMap imports = ContainerUtil.newLinkedHashMap();
        element.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                ResolveResult[] results;
                super.visitJSReferenceExpression(node);
                if (node.getQualifier() != null) {
                    return;
                }
                String referenceName = node.getReferenceName();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                for (ResolveResult result : results = node.multiResolve(false)) {
                    ES6ImportExportDeclaration es6Import;
                    PsiElement resultElement = result.getElement();
                    if (!result.isValidResult() || resultElement == null) continue;
                    PsiElement resultModule = ES6PsiUtil.findExternalModule(resultElement);
                    if (module.isEquivalentTo(resultModule) && !(resultElement instanceof ES6ImportedBinding) && !(resultElement instanceof ES6ImportSpecifierAlias)) {
                        if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)resultElement, (boolean)false)) continue;
                        List toProcess = ES6ImportHandler.isExportedWithNameOrDefault(resultElement) ? exportedLocals : locals;
                        toProcess.add(resultElement);
                        continue;
                    }
                    if (!(result instanceof JSResolveResult)) continue;
                    JSResolveResult jsResolveResult = (JSResolveResult)result;
                    ES6ImportExportDeclarationPart importPart = jsResolveResult.getES6Import();
                    ES6ImportExportDeclaration eS6ImportExportDeclaration = es6Import = importPart == null ? null : importPart.getDeclaration();
                    if (es6Import == null) {
                        if (resultElement instanceof ES6ImportedBinding) {
                            JSElement defaultElement;
                            Collection elements = ((ES6ImportedBinding)resultElement).findReferencedElements();
                            PsiElement item = (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
                            if (item instanceof ES6ExportDefaultAssignment && (defaultElement = ((ES6ExportDefaultAssignment)item).getStubSafeElement()) instanceof JSQualifiedNamedElement) {
                                item = defaultElement;
                            }
                            if (item != null) {
                                this.fillBinding(referenceName, item, (ES6ImportedBinding)resultElement);
                            }
                            return;
                        }
                        if (!(resultElement instanceof ES6ImportSpecifierAlias)) continue;
                        ES6ImportSpecifierAlias alias = (ES6ImportSpecifierAlias)resultElement;
                        PsiElement resolvedElement = alias.findAliasedElement();
                        ES6ImportExportSpecifier specifierElement = alias.findSpecifierElement();
                        if (resolvedElement != null && specifierElement != null) {
                            ES6ImportPsiUtil.CreateImportExportInfo info = this.createImportInfoForSpecifier(referenceName, (ES6ImportSpecifier)specifierElement, alias);
                            imports.put(info, resolvedElement);
                        }
                        return;
                    }
                    if (!(es6Import instanceof ES6ImportDeclaration) || !module.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)es6Import))) continue;
                    if (importPart instanceof ES6ImportSpecifier) {
                        ES6ImportSpecifier specifier = (ES6ImportSpecifier)importPart;
                        ES6ImportSpecifierAlias alias = specifier.getAlias();
                        ES6ImportPsiUtil.CreateImportExportInfo info = this.createImportInfoForSpecifier(referenceName, specifier, alias);
                        imports.put(info, resultElement);
                        continue;
                    }
                    if (!(importPart instanceof ES6ImportedBinding)) continue;
                    this.fillBinding(referenceName, resultElement, (ES6ImportedBinding)importPart);
                    return;
                }
            }

            private void fillBinding(@NotNull String referenceName, @NotNull PsiElement resultElement, @NotNull ES6ImportedBinding binding) {
                if (referenceName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceName", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1", "fillBinding"));
                }
                if (resultElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultElement", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1", "fillBinding"));
                }
                if (binding == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binding", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1", "fillBinding"));
                }
                ES6ImportPsiUtil.CreateImportExportInfo info = this.createImportInfoForBinding(referenceName, binding);
                imports.put(info, resultElement);
            }

            @NotNull
            private ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForBinding(String referenceName, ES6ImportedBinding binding) {
                ES6ImportPsiUtil.ImportExportType importType = binding.isNamespaceImport() ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
                ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, importType);
                if (createImportExportInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1", "createImportInfoForBinding"));
                }
                return createImportExportInfo;
            }

            @NotNull
            private ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForSpecifier(String referenceName, ES6ImportSpecifier specifier, ES6ImportSpecifierAlias alias) {
                ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = alias == null ? new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER) : new ES6ImportPsiUtil.CreateImportExportInfo(specifier.getCanonicalText(), referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                if (createImportExportInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo$1", "createImportInfoForSpecifier"));
                }
                return createImportExportInfo;
            }
        });
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = new ES6ReferenceExpressionsInfo(locals, exportedLocals, imports);
        if (eS6ReferenceExpressionsInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "getInfo"));
        }
        return eS6ReferenceExpressionsInfo;
    }

    public ES6ReferenceExpressionsInfo(@NotNull Collection<PsiElement> locals, @NotNull Collection<PsiElement> exportedLocals, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports) {
        if (locals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locals", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "<init>"));
        }
        if (exportedLocals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exportedLocals", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "<init>"));
        }
        if (imports == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imports", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "<init>"));
        }
        this.myLocals = locals;
        this.myExportedLocals = exportedLocals;
        this.myImports = imports;
    }

    @NotNull
    public Collection<PsiElement> getLocalReferencedElements() {
        Collection<PsiElement> collection = this.myLocals;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo", "getLocalReferencedElements"));
        }
        return collection;
    }

    public Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> getReferencedImports() {
        return this.myImports;
    }

    public Collection<PsiElement> getExportedLocalReferencedElements() {
        return this.myExportedLocals;
    }
}

