/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptCodeContextType;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExpressionContextType
extends TemplateContextType {
    protected JSExpressionContextType() {
        super("JS_EXPRESSION", JSBundle.message((String)"js.expression.context.type", (Object[])new Object[0]), JavaScriptCodeContextType.class);
    }

    public boolean isInContext(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/JSExpressionContextType", "isInContext"));
        }
        return JSExpressionContextType.isInContext(file.findElementAt(offset));
    }

    public static boolean isInContext(@Nullable PsiElement at) {
        JSReferenceExpression referenceExpression;
        if (!JavaScriptCodeContextType.areJavaScriptTemplatesApplicable(at)) {
            return false;
        }
        PsiElement parent = at.getParent();
        JSReferenceExpression jSReferenceExpression = referenceExpression = parent instanceof JSReferenceExpression ? (JSReferenceExpression)parent : null;
        if (referenceExpression != null && JSResolveUtil.isExprInStrictTypeContext(referenceExpression)) {
            return false;
        }
        if (referenceExpression == null || referenceExpression.getQualifier() != null) {
            return false;
        }
        if (parent.getParent() instanceof ES6Property && ((ES6Property)parent.getParent()).isShorthanded()) {
            return false;
        }
        return !(parent.getParent() instanceof JSExpressionStatement);
    }
}

