/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSSectionArrangementEntry;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSectionDetector;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSRearrangerBase
implements Rearranger<JSArrangementEntry>,
ArrangementStandardSettingsAware,
ArrangementSectionRuleAwareSettings {
    private static final Logger LOG = Logger.getInstance((String)JSRearrangerBase.class.getName());
    public static boolean dumpArrangementEntries = false;

    @Nullable
    public Pair<JSArrangementEntry, List<JSArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parseWithNew"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parseWithNew"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parseWithNew"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parseWithNew"));
        }
        LOG.assertTrue(root instanceof JSClass, (Object)String.format("Expected instance of JSClass but was %s", root.getClass().getName()));
        List<JSArrangementEntry> newEntries = this.processPsiElement(element, document, ContainerUtil.list((Object[])new TextRange[]{element.getTextRange()}), settings);
        JSArrangementEntry newEntry = (JSArrangementEntry)ContainerUtil.getFirstItem(newEntries);
        if (newEntry == null) {
            return null;
        }
        return Pair.create((Object)newEntry, this.processPsiElement(root, document, ranges, settings));
    }

    @NotNull
    public List<JSArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parse"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parse"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parse"));
        }
        if (!(root instanceof JSFile)) {
            List<JSArrangementEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parse"));
            }
            return list;
        }
        List<JSArrangementEntry> list = this.processPsiElement(root, document, ranges, settings);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "parse"));
        }
        return list;
    }

    @NotNull
    private List<JSArrangementEntry> processPsiElement(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "processPsiElement"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "processPsiElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "processPsiElement"));
        }
        ArrangementInfo arrangementInfo = new ArrangementInfo(ranges, document, settings);
        root.accept((PsiElementVisitor)this.createVisitor(arrangementInfo));
        if (ApplicationManager.getApplication().isUnitTestMode() && dumpArrangementEntries) {
            JSRearrangerBase.dumpArrangementEntries(document, arrangementInfo.getTopLevelEntries());
        }
        List<JSArrangementEntry> list = arrangementInfo.getTopLevelEntries();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "processPsiElement"));
        }
        return list;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return Collections.singletonList(new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        ArrangementSettingsToken type;
        if (token == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "token", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "isEnabled"));
        }
        if (this.getSupportedTypes().contains(token) || StdArrangementTokens.Order.KEEP.equals((Object)token) || StdArrangementTokens.Order.BY_NAME.equals((Object)token)) {
            return true;
        }
        ArrangementSettingsToken arrangementSettingsToken = type = current != null ? ArrangementUtil.parseType((ArrangementMatchCondition)current) : null;
        if (StdArrangementTokens.Regexp.NAME.equals((Object)token)) {
            return current == null || type != StdArrangementTokens.EntryType.CONSTRUCTOR && type != StdArrangementTokens.EntryType.STATIC_INIT;
        }
        if (current == null) {
            return this.getSupportedModifiers().contains(token);
        }
        if (type == null) {
            return true;
        }
        return this.isModifierEnabled(token, type, ArrangementUtil.extractTokens((ArrangementMatchCondition)current).keySet());
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        ArrayList result = ContainerUtil.newArrayList();
        result.add(this.getSupportedTypes());
        result.add(this.getVisibilityModifiers());
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "getMutexes"));
        }
        return arrayList;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtil.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, this.getSupportedTypes()), new CompositeArrangementSettingsToken(StdArrangementTokens.General.MODIFIER, this.getSupportedModifiers()), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    @NotNull
    protected Visitor createVisitor(@NotNull ArrangementInfo arrangementInfo) {
        if (arrangementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangementInfo", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "createVisitor"));
        }
        Visitor visitor = new Visitor(arrangementInfo);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "createVisitor"));
        }
        return visitor;
    }

    protected void postprocessClassMembers(@NotNull JSClass jsClass, @NotNull ClassArrangementInfo classArrangementInfo, @NotNull ArrangementInfo arrangementInfo) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "postprocessClassMembers"));
        }
        if (classArrangementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classArrangementInfo", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "postprocessClassMembers"));
        }
        if (arrangementInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arrangementInfo", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "postprocessClassMembers"));
        }
        Map<JSFunction, JSElementArrangementEntry> functionToEntry = classArrangementInfo.functionToEntry;
        Map<JSVariable, JSElementArrangementEntry> varToEntry = classArrangementInfo.fieldToEntry;
        for (Map.Entry<JSFunction, JSElementArrangementEntry> mapEntry : functionToEntry.entrySet()) {
            JSFunction function = mapEntry.getKey();
            String name = function.getName();
            if (!function.isSetProperty() || name == null) continue;
            JSElementArrangementEntry setterEntry = mapEntry.getValue();
            JSFunction getter = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
            JSElementArrangementEntry getterEntry = functionToEntry.get(getter);
            if (getterEntry == null) continue;
            setterEntry.addDependency(getterEntry);
        }
        if (JSRearrangerBase.groupPropertyFieldWithGetterSetter(arrangementInfo.getSettings())) {
            JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)jsClass);
            for (Map.Entry<JSVariable, JSElementArrangementEntry> mapEntry : varToEntry.entrySet()) {
                JSElementArrangementEntry propertyEntry;
                JSVariable jsVar = mapEntry.getKey();
                JSElementArrangementEntry varEntry = mapEntry.getValue();
                if (!StringUtil.startsWith((CharSequence)StringUtil.notNullize((String)jsVar.getName()), (CharSequence)codeStyleSettings.FIELD_PREFIX)) continue;
                String propertyName = JSRefactoringUtil.transformVarNameToAccessorName(jsVar.getName(), jsClass.getProject());
                JSFunction getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.GETTER);
                if (getterOrSetter == null) {
                    getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.SETTER);
                }
                if ((propertyEntry = getterOrSetter == null ? null : functionToEntry.get(getterOrSetter)) == null || propertyEntry.getType() == null) continue;
                varEntry.setType(propertyEntry.getType());
                varEntry.setModifiers(propertyEntry.getModifiers());
                propertyEntry.addDependency(varEntry);
            }
        }
    }

    @NotNull
    protected ArrangementSettingsToken detectFieldType(JSVariable variable) {
        ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.FIELD;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "detectFieldType"));
        }
        return arrangementSettingsToken;
    }

    protected abstract boolean isModifierEnabled(@NotNull ArrangementSettingsToken var1, @NotNull ArrangementSettingsToken var2, @NotNull Set<ArrangementSettingsToken> var3);

    @NotNull
    protected ArrangementSettingsToken detectFunctionType(@NotNull JSFunction function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "detectFunctionType"));
        }
        if (function.isConstructor()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.CONSTRUCTOR;
            if (arrangementSettingsToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "detectFunctionType"));
            }
            return arrangementSettingsToken;
        }
        if (function.isGetProperty()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.PROPERTY;
            if (arrangementSettingsToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "detectFunctionType"));
            }
            return arrangementSettingsToken;
        }
        if (function.isSetProperty()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.PROPERTY;
            if (arrangementSettingsToken == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "detectFunctionType"));
            }
            return arrangementSettingsToken;
        }
        ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.METHOD;
        if (arrangementSettingsToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "detectFunctionType"));
        }
        return arrangementSettingsToken;
    }

    @NotNull
    protected abstract Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner var1);

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getSupportedTypes();

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getVisibilityModifiers();

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getSupportedModifiers();

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "buildMatcher"));
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition);
    }

    private static <T extends ArrangementEntry> void dumpArrangementEntries(@Nullable Document document, List<T> entries) {
        StringBuilder builder = new StringBuilder();
        JSRearrangerBase.dumpArrangementEntries(document, entries, 0, builder);
        LOG.debug(builder.toString());
    }

    private static <T extends ArrangementEntry> void dumpArrangementEntries(@Nullable Document document, List<T> entries, int level, StringBuilder stringBuilder) {
        for (ArrangementEntry entry : entries) {
            stringBuilder.append(StringUtil.repeat((String)"\t", (int)level)).append(entry.toString()).append("\n").append(document != null ? document.getText(TextRange.create((int)entry.getStartOffset(), (int)entry.getEndOffset())) + "\n" : "");
            JSRearrangerBase.dumpArrangementEntries(document, entry.getChildren(), level + 1, stringBuilder);
        }
    }

    private static boolean groupPropertyFieldWithGetterSetter(@NotNull ArrangementSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "groupPropertyFieldWithGetterSetter"));
        }
        return ContainerUtil.or((Iterable)settings.getGroupings(), rule -> rule.getGroupingType() == StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER);
    }

    protected static void addRule(List<StdArrangementMatchRule> rules, ArrangementSettingsToken ... conditions) {
        if (conditions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "conditions", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "addRule"));
        }
        if (conditions.length == 1) {
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition(conditions[0]))));
            return;
        }
        ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        for (ArrangementSettingsToken condition : conditions) {
            composite.addOperand((ArrangementMatchCondition)new ArrangementAtomMatchCondition(condition));
        }
        rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)composite)));
    }

    private static boolean isWithinBounds(@NotNull TextRange range, @NotNull Collection<TextRange> ranges) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "isWithinBounds"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "isWithinBounds"));
        }
        return ContainerUtil.or(ranges, range1 -> {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/javascript/arrangement/JSRearrangerBase", "lambda$isWithinBounds$1"));
            }
            return range1.intersects(range);
        });
    }

    protected static class ArrangementInfo {
        private final Collection<TextRange> allowedRanges;
        private final Document document;
        private final ArrangementSettings mySettings;
        private final Stack<JSElementArrangementEntry> stack;
        private final Set<PsiComment> mySectionComments;
        private final List<JSArrangementEntry> topLevelEntries;
        private final ArrangementSectionDetector mySectionDetector;

        public ArrangementInfo(@NotNull Collection<TextRange> allowedRanges, @Nullable Document document, @NotNull ArrangementSettings settings) {
            if (allowedRanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allowedRanges", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "<init>"));
            }
            this.mySectionComments = ContainerUtil.newHashSet();
            this.topLevelEntries = ContainerUtil.newArrayList();
            this.allowedRanges = allowedRanges;
            this.document = document;
            this.mySettings = settings;
            this.stack = new Stack();
            this.mySectionDetector = new ArrangementSectionDetector(this.document, this.mySettings, data -> {
                JSElementArrangementEntry parent = this.getCurrentEntry();
                this.addEntry(parent, new JSSectionArrangementEntry(parent, data.getTextRange(), data.getToken(), data.getText()));
            });
        }

        public <T extends JSElement> void processWithCurrentEntry(@NotNull JSElementArrangementEntry entry, @NotNull T element, @NotNull Consumer<T> consumer) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "processWithCurrentEntry"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "processWithCurrentEntry"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "processWithCurrentEntry"));
            }
            this.stack.push(entry);
            consumer.consume(element);
            this.stack.pop();
        }

        @NotNull
        public List<JSArrangementEntry> getTopLevelEntries() {
            List<JSArrangementEntry> list = this.topLevelEntries;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "getTopLevelEntries"));
            }
            return list;
        }

        @NotNull
        public ArrangementSettings getSettings() {
            ArrangementSettings arrangementSettings = this.mySettings;
            if (arrangementSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "getSettings"));
            }
            return arrangementSettings;
        }

        @Nullable
        public JSElementArrangementEntry addEntryFromPsi(@NotNull JSElement element, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromPsi"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromPsi"));
            }
            if (modifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromPsi"));
            }
            return this.addEntryFromRange((PsiElement)element, (PsiElement)element, type, modifiers, name);
        }

        @Nullable
        public JSElementArrangementEntry addContainerEntry(@NotNull PsiElement element, @NotNull ArrangementSettingsToken type) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addContainerEntry"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addContainerEntry"));
            }
            return this.addEntryFromRange(element, element, ContainerUtil.set((Object[])new ArrangementSettingsToken[]{type}), Collections.emptySet(), null);
        }

        @Nullable
        public JSElementArrangementEntry addEntryFromRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            if (modifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            return this.addEntryFromRange(startElement, endElement, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{type}), modifiers, name);
        }

        @Nullable
        private JSElementArrangementEntry addEntryFromRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Set<ArrangementSettingsToken> types, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            if (modifiers == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiers", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntryFromRange"));
            }
            PsiComment leadingComment = this.processSectionComment(JSPsiImplUtils.findLeadingComment(startElement));
            PsiComment trailingComment = this.processSectionComment(JSPsiImplUtils.findTrailingEndOfLineComment(endElement));
            TextRange textRange = new TextRange(leadingComment != null ? leadingComment.getTextRange().getStartOffset() : startElement.getTextRange().getStartOffset(), trailingComment != null ? trailingComment.getTextRange().getEndOffset() : endElement.getTextRange().getEndOffset());
            TextRange range = this.document == null ? textRange : ArrangementUtil.expandToLineIfPossible((TextRange)textRange, (Document)this.document);
            JSElementArrangementEntry parent = this.getCurrentEntry();
            return this.addEntry(parent, new JSElementArrangementEntry(parent, name, types, modifiers, range));
        }

        @Nullable
        public PsiComment processSectionComment(@Nullable PsiComment comment) {
            if (comment == null || this.mySectionComments.contains(comment)) {
                return null;
            }
            if (this.mySectionDetector.processComment(comment)) {
                this.mySectionComments.add(comment);
                return null;
            }
            return comment;
        }

        @Nullable
        public <T extends JSArrangementEntry> T addEntry(@Nullable JSElementArrangementEntry parent, @NotNull T entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo", "addEntry"));
            }
            if (!JSRearrangerBase.isWithinBounds(new TextRange(entry.getStartOffset(), entry.getEndOffset()), this.allowedRanges)) {
                return null;
            }
            if (parent != null) {
                parent.addChild(entry);
            } else {
                this.topLevelEntries.add(entry);
            }
            return entry;
        }

        @Nullable
        private JSElementArrangementEntry getCurrentEntry() {
            return this.stack.isEmpty() ? null : this.stack.peek();
        }
    }

    protected static class ClassArrangementInfo {
        public final Map<JSVariable, JSElementArrangementEntry> fieldToEntry = new THashMap();
        public final Map<JSFunction, JSElementArrangementEntry> functionToEntry = new THashMap();

        protected ClassArrangementInfo() {
        }
    }

    protected class Visitor
    extends JSRecursiveElementVisitor {
        protected ArrangementInfo myArrangementInfo;
        private ClassArrangementInfo myClassArrangementInfo;

        public Visitor(ArrangementInfo arrangementInfo) {
            this.myArrangementInfo = arrangementInfo;
        }

        public void visitJSClass(JSClass jsClass) {
            JSElementArrangementEntry classEntry = this.myArrangementInfo.addContainerEntry((PsiElement)jsClass, StdArrangementTokens.EntryType.CLASS);
            if (classEntry == null) {
                return;
            }
            ClassArrangementInfo previousClassInfo = this.myClassArrangementInfo;
            this.myClassArrangementInfo = new ClassArrangementInfo();
            this.visitWithCurrentEntry((JSElement)jsClass, classEntry);
            JSRearrangerBase.this.postprocessClassMembers(jsClass, this.myClassArrangementInfo, this.myArrangementInfo);
            this.myClassArrangementInfo = previousClassInfo;
        }

        public void visitJSVarStatement(JSVarStatement varStatement) {
            if (!this.isClassMember((JSElement)varStatement)) {
                super.visitJSVarStatement(varStatement);
                return;
            }
            JSVariable variable = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables());
            if (variable == null) {
                return;
            }
            ArrangementSettingsToken type = JSRearrangerBase.this.detectFieldType(variable);
            JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromPsi((JSElement)varStatement, type, JSRearrangerBase.this.detectModifiers((JSAttributeListOwner)variable), variable.getName());
            if (entry != null) {
                this.visitWithCurrentEntry((JSElement)varStatement, entry);
                JSVariable[] variables = varStatement.getVariables();
                if (variables.length == 1 && !variables[0].isConst() && this.myClassArrangementInfo != null) {
                    this.myClassArrangementInfo.fieldToEntry.put(variables[0], entry);
                }
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
            if (!this.isClassMember((JSElement)function)) {
                super.visitJSFunctionDeclaration(function);
                return;
            }
            JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromPsi((JSElement)function, JSRearrangerBase.this.detectFunctionType(function), JSRearrangerBase.this.detectModifiers((JSAttributeListOwner)function), function.getName());
            if (entry != null && this.myClassArrangementInfo != null) {
                this.myClassArrangementInfo.functionToEntry.put(function, entry);
                this.visitWithCurrentEntry((JSElement)function, entry);
            }
        }

        public void visitJSBlock(JSBlockStatement initializer) {
            if (!this.isClassMember((JSElement)initializer)) {
                super.visitJSBlock(initializer);
                return;
            }
            JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromPsi((JSElement)initializer, StdArrangementTokens.EntryType.STATIC_INIT, Collections.emptySet(), null);
            if (entry != null) {
                this.visitWithCurrentEntry((JSElement)initializer, entry);
            }
        }

        public void visitComment(PsiComment comment) {
            this.myArrangementInfo.processSectionComment(comment);
        }

        private boolean isClassMember(@NotNull JSElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$Visitor", "isClassMember"));
            }
            return element.getParent() instanceof JSClass;
        }

        protected void visitWithCurrentEntry(@NotNull JSElement varStatement, @NotNull JSElementArrangementEntry entry) {
            if (varStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varStatement", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$Visitor", "visitWithCurrentEntry"));
            }
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/lang/javascript/arrangement/JSRearrangerBase$Visitor", "visitWithCurrentEntry"));
            }
            this.myArrangementInfo.processWithCurrentEntry(entry, varStatement, theEntry -> theEntry.acceptChildren((PsiElementVisitor)this));
        }
    }
}

