/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.boilerplate.AbstractGithubTagDownloadedProjectGenerator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.GithubTagInfo;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoundationProjectGenerator
extends AbstractGithubTagDownloadedProjectGenerator {
    public static final String NAME = "Foundation";

    @NotNull
    protected String getDisplayName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "getDisplayName"));
        }
        return NAME;
    }

    @NotNull
    public String getGithubUserName() {
        if ("zurb" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "getGithubUserName"));
        }
        return "zurb";
    }

    @NotNull
    public String getGithubRepositoryName() {
        if ("foundation-sites" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "getGithubRepositoryName"));
        }
        return "foundation-sites";
    }

    @NotNull
    public String getDescription() {
        if ("<html>Responsive front-end framework <a href='http://foundation.zurb.com'>http://foundation.zurb.com</a></html>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "getDescription"));
        }
        return "<html>Responsive front-end framework <a href='http://foundation.zurb.com'>http://foundation.zurb.com</a></html>";
    }

    @Nullable
    public Integer getPreferredDescriptionWidth() {
        return 390;
    }

    public String getPrimaryZipArchiveUrlForDownload(@NotNull GithubTagInfo tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "getPrimaryZipArchiveUrlForDownload"));
        }
        return null;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull GithubTagInfo tag, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "generateProject"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "generateProject"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            FoundationProjectGenerator.generateTestProject(baseDir);
            return;
        }
        super.generateProject(project, baseDir, tag, module);
        File baseIoDir = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        List<String> ignoredFiles = FoundationProjectGenerator.parseIgnoredFiles(baseIoDir);
        for (String ignoredFile : ignoredFiles) {
            FileUtil.delete((File)new File(baseIoDir, ignoredFile));
        }
        FileUtil.delete((File)new File(baseIoDir, "bower.json"));
    }

    @NotNull
    private static List<String> parseIgnoredFiles(@NotNull File baseDir) {
        block7: {
            List list;
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "parseIgnoredFiles"));
            }
            File bowerJson = new File(baseDir, "bower.json");
            if (!bowerJson.isFile()) {
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "parseIgnoredFiles"));
                }
                return list2;
            }
            try {
                String text = FileUtil.loadFile((File)bowerJson);
                JsonElement root = new JsonParser().parse(text);
                if (!root.isJsonObject()) break block7;
                JsonObject rootObj = root.getAsJsonObject();
                List ignore = JsonUtil.getChildAsStringList((JsonObject)rootObj, (String)"ignore");
                list = ContainerUtil.notNullize((List)ignore);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "parseIgnoredFiles"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "parseIgnoredFiles"));
        }
        return list;
    }

    private static void generateTestProject(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/FoundationProjectGenerator", "generateTestProject"));
        }
        File extractToDir = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        File fixtureZipArchive = new File(PathManager.getHomePath(), "plugins/JavaScriptLanguage/testData/projectWizard/foundation-5.3.0.zip");
        if (!fixtureZipArchive.isFile()) {
            throw new RuntimeException("Cannot find test data " + fixtureZipArchive.getAbsolutePath());
        }
        try {
            ZipUtil.unzip(null, (File)extractToDir, (File)fixtureZipArchive, null, null, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Foundation;
    }
}

