/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPsiUtil {
    private JSPsiUtil() {
    }

    @Nullable
    public static JSCallExpression getCallExpression(@Nullable PsiElement statement) {
        if (statement instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)statement).getExpression();
            return (JSCallExpression)ObjectUtils.tryCast((Object)expression, JSCallExpression.class);
        }
        return null;
    }

    @Nullable
    public static String getSingleArgumentAsString(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length == 1) {
            return JSPsiUtil.getStringLiteralValue(args[0]);
        }
        return null;
    }

    @Nullable
    public static String getFirstArgumentAsString(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length > 0) {
            return JSPsiUtil.getStringLiteralValue(args[0]);
        }
        return null;
    }

    @Nullable
    public static JSLiteralExpression getFirstArgumentAsStringLiteral(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length > 0) {
            return JSPsiUtil.asStringLiteral(args[0]);
        }
        return null;
    }

    @Nullable
    public static JSObjectLiteralExpression getFirstArgumentAsObjectLiteral(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length > 0) {
            return (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)args[0], JSObjectLiteralExpression.class);
        }
        return null;
    }

    @Nullable
    public static String getStringLiteralValue(@Nullable JSExpression expr) {
        JSLiteralExpression literalExpression = JSPsiUtil.asStringLiteral(expr);
        if (literalExpression != null) {
            return JSPsiUtil.getStringLiteralValue(literalExpression);
        }
        return null;
    }

    @NotNull
    public static String getStringLiteralValue(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/lang/javascript/buildTools/JSPsiUtil", "getStringLiteralValue"));
        }
        String string = StringUtil.unquoteString((String)literalExpression.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/JSPsiUtil", "getStringLiteralValue"));
        }
        return string;
    }

    @Nullable
    public static JSLiteralExpression asStringLiteral(@Nullable JSExpression expr) {
        JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)expr, JSLiteralExpression.class);
        if (literalExpression != null && literalExpression.isQuotedLiteral()) {
            return literalExpression;
        }
        return null;
    }

    public static boolean isRequireCall(@NotNull JSCallExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/lang/javascript/buildTools/JSPsiUtil", "isRequireCall"));
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr.getMethodExpression(), JSReferenceExpression.class);
        return refExpr != null && "require".equals(refExpr.getReferenceName()) && refExpr.getQualifier() == null;
    }

    @Nullable
    public static JSProperty findPropertyByName(@Nullable JSObjectLiteralExpression objectLiteral, @NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/lang/javascript/buildTools/JSPsiUtil", "findPropertyByName"));
        }
        if (objectLiteral == null) {
            return null;
        }
        for (JSProperty property : objectLiteral.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }
}

