/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSHandlersFactory {
    public static final LanguageExtension<JSHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.handlersFactory");
    private static final JSHandlersFactory DEFAULT_INSTANCE = new JSHandlersFactory();

    @NotNull
    public static JSHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        JSHandlersFactory jSHandlersFactory = JSHandlersFactory.forLanguage(dialect);
        if (jSHandlersFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSHandlersFactory", "forElement"));
        }
        return jSHandlersFactory;
    }

    @NotNull
    public static JSHandlersFactory forLanguage(@Nullable Language dialect) {
        JSHandlersFactory dialectSpecificFactory = dialect != null ? (JSHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSHandlersFactory jSHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSHandlersFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSHandlersFactory", "forLanguage"));
        }
        return jSHandlersFactory;
    }

    @NotNull
    public JSCompletionKeywordsContributor newCompletionKeywordsContributor() {
        JSCompletionKeywordsContributor jSCompletionKeywordsContributor = new JSCompletionKeywordsContributor();
        if (jSCompletionKeywordsContributor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSHandlersFactory", "newCompletionKeywordsContributor"));
        }
        return jSCompletionKeywordsContributor;
    }

    public Class<? extends JSCodeStyleSettings> getCodeStyleSettingsClass() {
        return JSCodeStyleSettings.class;
    }
}

