/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQualifiedItemProcessor<T extends ResultSink>
extends QualifiedItemProcessor<T> {
    protected static final Key<JSTypeSubstitutor> TYPESCRIPT_GENERICS = Key.create((String)"ts.generics.resolve.state");

    public TypeScriptQualifiedItemProcessor(T sink, PsiFile containingFile) {
        super(sink, containingFile);
    }

    public static boolean processNamespaceChildren(ResolveProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, JSQualifiedNamedElement element) {
        if (element instanceof JSVariable) {
            if (processor.getAccessibilityProcessingHandler().isProcessStatics() && !JSResolveUtil.processDeclarationsInScope((JSElement)element, processor, state, lastParent, place)) {
                return false;
            }
        } else {
            if (element instanceof TypeScriptImportStatement) {
                return true;
            }
            if (!element.processDeclarations((PsiScopeProcessor)processor, state, lastParent, place)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void handleActionScriptFunctionExpressionEvents(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "handleActionScriptFunctionExpressionEvents"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NotNull JSType _type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (_type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_type", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "process"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "process"));
        }
        JSType type = JSTypeUtils.unwrapDecorations(_type);
        String name = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        PsiElement sourceElement = type.getSource().getSourceElement();
        if (name == null || sourceElement == null) {
            super.process(_type, evaluateContext, source);
            return;
        }
        Collection<JSQualifiedNamedElement> elements = this.getElements(source, name, sourceElement);
        if (elements.isEmpty()) {
            super.process(_type, evaluateContext, source);
            return;
        }
        JSTypeSubstitutor substitutor = TypeScriptQualifiedItemProcessor.getTypeSubstitutor(type, elements);
        ResolveState state = substitutor == null ? ResolveState.initial() : ResolveState.initial().put(TYPESCRIPT_GENERICS, (Object)substitutor);
        for (JSQualifiedNamedElement element : elements) {
            if (element instanceof TypeScriptTypeAlias) {
                JSType declaration = ((TypeScriptTypeAlias)element).getParsedTypeDeclaration();
                if (declaration == null) continue;
                JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT, e -> {
                    if (evaluateContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "lambda$process$0"));
                    }
                    this.process(JSTypeUtils.applyGenericArguments(declaration, (Map<String, JSType>)substitutor), evaluateContext, source);
                });
                continue;
            }
            boolean savedLocalResolve = this.isLocalResolve();
            boolean savedProcessStatics = this.getAccessibilityProcessingHandler().isProcessStatics();
            try {
                boolean isModule = element instanceof TypeScriptModule;
                if (isModule) {
                    this.setLocalResolve(true);
                }
                if (type instanceof JSNamedType) {
                    this.getAccessibilityProcessingHandler().setProcessStatics(((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC);
                }
                TypeScriptQualifiedItemProcessor.processNamespaceChildren(this, state, (PsiElement)element, this.place, element);
            }
            finally {
                this.setLocalResolve(savedLocalResolve);
                this.getAccessibilityProcessingHandler().setProcessStatics(savedProcessStatics);
            }
        }
        if (type.getSource().isExplicitlyDeclared() && this.place != null && DialectDetector.isTypeScript(this.place)) {
            this.resolved = QualifiedItemProcessor.TypeResolveState.Resolved;
        }
    }

    @NotNull
    private Collection<JSQualifiedNamedElement> getElements(@Nullable PsiElement source, @NotNull String name, @NotNull PsiElement sourceElement) {
        SmartList elements;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "getElements"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "getElements"));
        }
        if (source instanceof JSQualifiedNamedElement && name.equals(((JSQualifiedNamedElement)source).getQualifiedName()) && TypeScriptPsiUtil.isNamedTypeDefinition(source)) {
            elements = Collections.singleton((JSQualifiedNamedElement)source);
        } else {
            PsiElement sourceToResolve = sourceElement;
            PsiFile file = sourceElement.getContainingFile();
            if (file != null && TypeScriptLibraryProvider.LIBS_D_TS.contains(file.getName()) && this.place != null) {
                sourceToResolve = this.place;
            }
            JSTypeResolveResult resolveResult = TypeScriptImportHandler.getInstance().resolveTypeName(name, sourceToResolve);
            elements = new SmartList();
            for (PsiElement psiElement : resolveResult.getElements()) {
                if (!(psiElement instanceof JSQualifiedNamedElement)) continue;
                elements.add((JSQualifiedNamedElement)psiElement);
            }
        }
        SmartList smartList = elements;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "getElements"));
        }
        return smartList;
    }

    @Nullable
    private static JSTypeSubstitutor getTypeSubstitutor(@Nullable JSType type, @NotNull Collection<JSQualifiedNamedElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "getTypeSubstitutor"));
        }
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(type);
        if (arguments == null) {
            return null;
        }
        JSClass candidateClass = null;
        for (JSQualifiedNamedElement element : elements) {
            if (!(element instanceof JSClass)) continue;
            candidateClass = (JSClass)element;
            break;
        }
        if (candidateClass instanceof TypeScriptTypeParameterListOwner) {
            return TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)candidateClass, arguments);
        }
        return null;
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "executeAcceptedElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedItemProcessor", "executeAcceptedElement"));
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadImplementation()) {
            return true;
        }
        return super.executeAcceptedElement(element, state);
    }
}

