/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedItemProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveProcessor
extends TypeScriptQualifiedItemProcessor<ResolveResultSink> {
    private final NullableLazyValue<List<JSType>> myArgumentTypes;
    private final boolean myStrictTypeContext;
    private final boolean myIncompleteCode;
    private final boolean myStrictTypeContainerContext;
    private final JSCallExpression myCallParent;

    public TypeScriptResolveProcessor(String referenceName, PsiFile containingFile, JSExpression _place, boolean incompleteCode) {
        super(new ResolveResultSink((PsiElement)_place, referenceName), containingFile);
        JSReferenceExpression topRefExpression;
        this.myStrictTypeContext = _place instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)_place);
        this.myIncompleteCode = incompleteCode;
        this.myStrictTypeContainerContext = !this.myStrictTypeContext ? (topRefExpression = TypeScriptResolveProcessor.getTopRefExpression((PsiElement)_place)) != null && JSResolveUtil.isExprInStrictTypeContext(topRefExpression) : false;
        PsiElement parent = this.place.getParent();
        while (parent instanceof JSParenthesizedExpressionImpl) {
            parent = parent.getParent();
        }
        this.myCallParent = parent instanceof JSCallExpression ? (JSCallExpression)parent : null;
        this.myArgumentTypes = NullableLazyValue.createValue(() -> {
            if (this.myCallParent == null) {
                return null;
            }
            return TypeScriptGenericTypesEvaluator.getArgumentTypesForSignatureChecking(this.myCallParent);
        });
    }

    @Nullable
    private static JSReferenceExpression getTopRefExpression(@Nullable PsiElement _place) {
        JSReferenceExpression result = null;
        while (_place instanceof JSReferenceExpression) {
            result = (JSReferenceExpression)_place;
            _place = _place.getParent();
        }
        return result;
    }

    @Override
    protected boolean needProcessTypeMembers(PsiElement element, PsiElement clazz) {
        if (clazz instanceof TypeScriptModule) {
            String moduleName = ((TypeScriptModule)clazz).getName();
            String elementName = null;
            if (element instanceof PsiNamedElement) {
                elementName = ((PsiNamedElement)element).getName();
            } else if (element instanceof JSReferenceExpression) {
                elementName = ((JSReferenceExpression)element).getReferenceName();
            }
            if (Comparing.equal((String)elementName, (String)moduleName)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isSpecifierAcceptable(ES6ImportExportSpecifier specifier) {
        if (this.myStrictTypeContext || this.myStrictTypeContainerContext) {
            return TypeScriptPsiUtil.referencesNamedTypeContainer(specifier);
        }
        return super.isSpecifierAcceptable(specifier);
    }

    private PsiElement checkParameterTypes(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "checkParameterTypes"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "checkParameterTypes"));
        }
        if (this.myCallParent == null) {
            return element;
        }
        JSTypeSubstitutor genericArguments = TypeScriptGenericTypesEvaluator.addExplicitGenericArgumentsFromCall(element, (PsiElement)this.myCallParent, (JSTypeSubstitutor)state.get(TYPESCRIPT_GENERICS));
        JSResolveResult resolveResult = TypeScriptSignatureChooser.checkParameterTypes(element, (List)this.myArgumentTypes.getValue(), genericArguments, this.myCallParent instanceof JSNewExpression);
        if (!resolveResult.isValidResult()) {
            PsiElement elementToResolve = element;
            if (TypeScriptSignatureChooser.isOverloadImplementation(element) && !this.myIncompleteCode) {
                elementToResolve = resolveResult.getElement();
            }
            this.addPossibleCandidateResult(elementToResolve, resolveResult.getResolveProblemKey());
            return null;
        }
        return this.myIncompleteCode ? element : resolveResult.getElement();
    }

    @Override
    public ResolveResult[] getResultsAsResolveResults() {
        ResolveResult[] results = super.getResultsAsResolveResults();
        if (this.myIncompleteCode) {
            return results;
        }
        if (TypeScriptResolveProcessor.isTypeMismatchResult(results)) {
            results[0] = new JSResolveResult(results[0].getElement());
            return results;
        }
        if (results.length > 0 && this.myCallParent != null) {
            return TypeScriptPsiUtil.chooseOverloads(results);
        }
        return results;
    }

    private static boolean isTypeMismatchResult(ResolveResult[] results) {
        return results.length == 1 && !results[0].isValidResult() && results[0] instanceof JSResolveResult && ((JSResolveResult)results[0]).getResolveProblemKey() == "javascript.argument.types.mismatch";
    }

    @Override
    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "execute"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "execute"));
        }
        if (this.myStrictTypeContext && !TypeScriptPsiUtil.isNamedTypeDefinition(element)) {
            return true;
        }
        if (this.myStrictTypeContainerContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(element)) {
            return true;
        }
        if (!(this.myStrictTypeContext || !(this.place instanceof JSReferenceExpression) || !(element instanceof TypeScriptInterface) || this.place instanceof TypeScriptModule || this.place instanceof TypeScriptEntityName || this.place instanceof TypeScriptImportStatement || this.place.getParent() instanceof JSExportAssignment)) {
            return true;
        }
        return super.execute(element, state);
    }

    @Override
    protected boolean executeAcceptedElement(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "executeAcceptedElement"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "executeAcceptedElement"));
        }
        if (element instanceof TypeScriptFunction && ((TypeScriptFunction)element).isOverloadDeclaration()) {
            return true;
        }
        PsiElement function = this.checkParameterTypes(element, state);
        if (function == null) {
            return false;
        }
        element = function;
        if (element instanceof TypeScriptIndexSignature && this.myName != null && ((TypeScriptIndexSignature)element).getMemberParameterType() instanceof JSStringType) {
            return ((ResolveResultSink)this.getResultSink()).addResult(element, state, this);
        }
        return super.executeAcceptedElement(element, state);
    }

    @Override
    @Nullable
    protected PsiElement getConstructor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveProcessor", "getConstructor"));
        }
        PsiElement constructor = null;
        ResolveResult[] results = JSClassUtils.resolveES6Constructor((JSClass)element, (JSExpression)this.place);
        PsiElement validElement = null;
        boolean addedPossibleCandidate = false;
        for (ResolveResult resolveResult : results) {
            if (resolveResult.isValidResult()) {
                validElement = resolveResult.getElement();
                continue;
            }
            if (!this.myIncompleteCode && addedPossibleCandidate) continue;
            this.addPossibleCandidateResult(resolveResult.getElement(), "javascript.argument.types.mismatch");
            addedPossibleCandidate = true;
        }
        if (validElement == null) {
            return null;
        }
        PsiElement constrOrClass = validElement;
        if (constrOrClass instanceof JSFunction && JSUtils.getMemberContainingClass(constrOrClass) == element) {
            constructor = constrOrClass;
        }
        return constructor == null ? element : constructor;
    }
}

